/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.expression;

import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.expression.BaseExpression;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class ArrayExpression
extends BaseExpression {
    private final List<Expression> expressions;

    public ArrayExpression(@NonNull ParserRuleContext context, @NonNull List<Expression> expressions) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (expressions == null) {
            throw new NullPointerException("expressions is marked non-null but is null");
        }
        this.expressions = expressions;
    }

    public ArrayExpression(@NonNull List<Expression> expressions) {
        if (expressions == null) {
            throw new NullPointerException("expressions is marked non-null but is null");
        }
        this.expressions = expressions;
    }

    @Override
    protected String doToString() {
        return "[" + this.expressions.stream().map(Object::toString).collect(Collectors.joining(",")) + "]";
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayExpression)) {
            return false;
        }
        ArrayExpression other = (ArrayExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Expression> this$expressions = this.getExpressions();
        List<Expression> other$expressions = other.getExpressions();
        return !(this$expressions == null ? other$expressions != null : !((Object)this$expressions).equals(other$expressions));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ArrayExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Expression> $expressions = this.getExpressions();
        result = result * 59 + ($expressions == null ? 43 : ((Object)$expressions).hashCode());
        return result;
    }
}

