/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.expression;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseExpression
extends BaseStatement
implements Expression {
    private Expression nextExpr;
    private Expression.ReferenceOperator nextOperator;
    private Expression parentExpr;
    private Expression.ReferenceOperator parentOperator;

    protected BaseExpression() {
    }

    protected BaseExpression(TerminalNode terminalNode) {
        super(terminalNode);
    }

    protected BaseExpression(ParserRuleContext ruleNode) {
        super(ruleNode);
    }

    protected BaseExpression(ParserRuleContext beginRule, TerminalNode endNode) {
        super(beginRule, endNode);
    }

    protected BaseExpression(TerminalNode beginNode, TerminalNode endNode) {
        super(beginNode, endNode);
    }

    protected BaseExpression(TerminalNode beginNode, ParserRuleContext endRule) {
        super(beginNode, endRule);
    }

    protected BaseExpression(ParserRuleContext beginRule, ParserRuleContext endRule) {
        super(beginRule, endRule);
    }

    @Override
    public Expression reference(@NonNull Expression nextExpr, @NonNull Expression.ReferenceOperator operator) {
        if (nextExpr == null) {
            throw new NullPointerException("nextExpr is marked non-null but is null");
        }
        if (operator == null) {
            throw new NullPointerException("operator is marked non-null but is null");
        }
        if (this.nextExpr == nextExpr && this.nextOperator == operator) {
            return nextExpr;
        }
        this.nextExpr = nextExpr;
        this.nextOperator = operator;
        nextExpr.parentReference(this, operator);
        return nextExpr;
    }

    @Override
    public Expression parentReference(@NonNull Expression parentExpr, @NonNull Expression.ReferenceOperator operator) {
        if (parentExpr == null) {
            throw new NullPointerException("parentExpr is marked non-null but is null");
        }
        if (operator == null) {
            throw new NullPointerException("operator is marked non-null but is null");
        }
        if (this.parentExpr == parentExpr && this.parentOperator == operator) {
            return parentExpr;
        }
        this.parentExpr = parentExpr;
        this.parentOperator = operator;
        parentExpr.reference(this, operator);
        return parentExpr;
    }

    @Override
    public Expression getReference() {
        return this.nextExpr;
    }

    @Override
    public Expression getParentReference() {
        return this.parentExpr;
    }

    @Override
    public Expression.ReferenceOperator getReferenceOperator() {
        return this.nextOperator;
    }

    @Override
    public Expression.ReferenceOperator getParentReferenceOperator() {
        return this.parentOperator;
    }

    protected abstract String doToString();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String toString = this.doToString();
        if (StringUtils.isEmpty((CharSequence)toString)) {
            toString = "";
        }
        if (this.parentExpr != null && this.parentOperator != null) {
            builder.append(this.parentOperator.wrap(toString));
        } else {
            builder.append(toString);
        }
        if (this.nextExpr == null) {
            return builder.toString();
        }
        return builder.append(this.nextExpr.toString()).toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseExpression)) {
            return false;
        }
        BaseExpression other = (BaseExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$nextExpr = this.nextExpr;
        Expression other$nextExpr = other.nextExpr;
        if (this$nextExpr == null ? other$nextExpr != null : !this$nextExpr.equals(other$nextExpr)) {
            return false;
        }
        Expression.ReferenceOperator this$nextOperator = this.nextOperator;
        Expression.ReferenceOperator other$nextOperator = other.nextOperator;
        return !(this$nextOperator == null ? other$nextOperator != null : !((Object)((Object)this$nextOperator)).equals((Object)other$nextOperator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $nextExpr = this.nextExpr;
        result = result * 59 + ($nextExpr == null ? 43 : $nextExpr.hashCode());
        Expression.ReferenceOperator $nextOperator = this.nextOperator;
        result = result * 59 + ($nextOperator == null ? 43 : ((Object)((Object)$nextOperator)).hashCode());
        return result;
    }
}

