/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.expression;

import com.oceanbase.tools.sqlparser.statement.expression.BaseExpression;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class ColumnReference
extends BaseExpression {
    private final String schema;
    private final String relation;
    private final String column;
    private String userVariable;

    public ColumnReference(@NonNull ParserRuleContext context, String schema, String relation, @NonNull String column) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        this.schema = schema;
        this.relation = relation;
        this.column = column;
    }

    public ColumnReference(String schema, String relation, @NonNull String column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        this.schema = schema;
        this.relation = relation;
        this.column = column;
    }

    @Override
    public String doToString() {
        StringBuilder builder = new StringBuilder();
        if (this.schema != null) {
            builder.append(this.schema).append(".");
        }
        if (this.relation != null) {
            builder.append(this.relation).append(".");
        }
        builder.append(this.column);
        if (this.userVariable != null) {
            builder.append(this.userVariable);
        }
        return builder.toString();
    }

    public String getSchema() {
        return this.schema;
    }

    public String getRelation() {
        return this.relation;
    }

    public String getColumn() {
        return this.column;
    }

    public String getUserVariable() {
        return this.userVariable;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnReference)) {
            return false;
        }
        ColumnReference other = (ColumnReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$relation = this.getRelation();
        String other$relation = other.getRelation();
        if (this$relation == null ? other$relation != null : !this$relation.equals(other$relation)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        String this$userVariable = this.getUserVariable();
        String other$userVariable = other.getUserVariable();
        return !(this$userVariable == null ? other$userVariable != null : !this$userVariable.equals(other$userVariable));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ColumnReference;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : $relation.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        String $userVariable = this.getUserVariable();
        result = result * 59 + ($userVariable == null ? 43 : $userVariable.hashCode());
        return result;
    }

    public void setUserVariable(String userVariable) {
        this.userVariable = userVariable;
    }
}

