/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.expression;

import com.oceanbase.tools.sqlparser.statement.expression.BaseExpression;
import com.oceanbase.tools.sqlparser.statement.expression.JsonOnOption;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

public class JsonOption
extends BaseExpression {
    private boolean truncate;
    private boolean pretty;
    private boolean ascii;
    private boolean asis;
    private boolean multiValue;
    private JsonOnOption onOption;
    private StrictMode strictMode;
    private ScalarsMode scalarsMode;
    private UniqueMode uniqueMode;
    private WrapperMode wrapperMode;

    public JsonOption(@NonNull ParserRuleContext context) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    public JsonOption(@NonNull TerminalNode terminalNode) {
        super(terminalNode);
        if (terminalNode == null) {
            throw new NullPointerException("terminalNode is marked non-null but is null");
        }
    }

    public JsonOption(@NonNull TerminalNode beginNode, @NonNull ParserRuleContext endRule) {
        super(beginNode, endRule);
        if (beginNode == null) {
            throw new NullPointerException("beginNode is marked non-null but is null");
        }
        if (endRule == null) {
            throw new NullPointerException("endRule is marked non-null but is null");
        }
    }

    public JsonOption(@NonNull ParserRuleContext beginRule, @NonNull ParserRuleContext endRule) {
        super(beginRule, endRule);
        if (beginRule == null) {
            throw new NullPointerException("beginRule is marked non-null but is null");
        }
        if (endRule == null) {
            throw new NullPointerException("endRule is marked non-null but is null");
        }
    }

    @Override
    protected String doToString() {
        StringBuilder builder = new StringBuilder();
        if (this.strictMode != null) {
            builder.append(" ").append(this.strictMode.name());
        }
        if (this.truncate) {
            builder.append(" TRUNCATE");
        }
        if (this.scalarsMode != null) {
            builder.append(" ").append(this.scalarsMode.name().replace("_", " "));
        }
        if (this.pretty) {
            builder.append(" PRETTY");
        }
        if (this.ascii) {
            builder.append(" ASCII");
        }
        if (this.uniqueMode != null) {
            builder.append(" ").append(this.uniqueMode.name().replace("_", " "));
        }
        if (this.wrapperMode != null) {
            builder.append(" ").append(this.wrapperMode.name().replace("_", " "));
        }
        if (this.asis) {
            builder.append(" ASIS");
        }
        if (this.onOption != null) {
            builder.append(" ").append(this.onOption);
        }
        if (this.multiValue) {
            builder.append(" MULTIVALUE");
        }
        return builder.toString();
    }

    public boolean isTruncate() {
        return this.truncate;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public boolean isAscii() {
        return this.ascii;
    }

    public boolean isAsis() {
        return this.asis;
    }

    public boolean isMultiValue() {
        return this.multiValue;
    }

    public JsonOnOption getOnOption() {
        return this.onOption;
    }

    public StrictMode getStrictMode() {
        return this.strictMode;
    }

    public ScalarsMode getScalarsMode() {
        return this.scalarsMode;
    }

    public UniqueMode getUniqueMode() {
        return this.uniqueMode;
    }

    public WrapperMode getWrapperMode() {
        return this.wrapperMode;
    }

    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public void setAscii(boolean ascii) {
        this.ascii = ascii;
    }

    public void setAsis(boolean asis) {
        this.asis = asis;
    }

    public void setMultiValue(boolean multiValue) {
        this.multiValue = multiValue;
    }

    public void setOnOption(JsonOnOption onOption) {
        this.onOption = onOption;
    }

    public void setStrictMode(StrictMode strictMode) {
        this.strictMode = strictMode;
    }

    public void setScalarsMode(ScalarsMode scalarsMode) {
        this.scalarsMode = scalarsMode;
    }

    public void setUniqueMode(UniqueMode uniqueMode) {
        this.uniqueMode = uniqueMode;
    }

    public void setWrapperMode(WrapperMode wrapperMode) {
        this.wrapperMode = wrapperMode;
    }

    public JsonOption() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonOption)) {
            return false;
        }
        JsonOption other = (JsonOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isTruncate() != other.isTruncate()) {
            return false;
        }
        if (this.isPretty() != other.isPretty()) {
            return false;
        }
        if (this.isAscii() != other.isAscii()) {
            return false;
        }
        if (this.isAsis() != other.isAsis()) {
            return false;
        }
        if (this.isMultiValue() != other.isMultiValue()) {
            return false;
        }
        JsonOnOption this$onOption = this.getOnOption();
        JsonOnOption other$onOption = other.getOnOption();
        if (this$onOption == null ? other$onOption != null : !((Object)this$onOption).equals(other$onOption)) {
            return false;
        }
        StrictMode this$strictMode = this.getStrictMode();
        StrictMode other$strictMode = other.getStrictMode();
        if (this$strictMode == null ? other$strictMode != null : !((Object)((Object)this$strictMode)).equals((Object)other$strictMode)) {
            return false;
        }
        ScalarsMode this$scalarsMode = this.getScalarsMode();
        ScalarsMode other$scalarsMode = other.getScalarsMode();
        if (this$scalarsMode == null ? other$scalarsMode != null : !((Object)((Object)this$scalarsMode)).equals((Object)other$scalarsMode)) {
            return false;
        }
        UniqueMode this$uniqueMode = this.getUniqueMode();
        UniqueMode other$uniqueMode = other.getUniqueMode();
        if (this$uniqueMode == null ? other$uniqueMode != null : !((Object)((Object)this$uniqueMode)).equals((Object)other$uniqueMode)) {
            return false;
        }
        WrapperMode this$wrapperMode = this.getWrapperMode();
        WrapperMode other$wrapperMode = other.getWrapperMode();
        return !(this$wrapperMode == null ? other$wrapperMode != null : !((Object)((Object)this$wrapperMode)).equals((Object)other$wrapperMode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JsonOption;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isTruncate() ? 79 : 97);
        result = result * 59 + (this.isPretty() ? 79 : 97);
        result = result * 59 + (this.isAscii() ? 79 : 97);
        result = result * 59 + (this.isAsis() ? 79 : 97);
        result = result * 59 + (this.isMultiValue() ? 79 : 97);
        JsonOnOption $onOption = this.getOnOption();
        result = result * 59 + ($onOption == null ? 43 : ((Object)$onOption).hashCode());
        StrictMode $strictMode = this.getStrictMode();
        result = result * 59 + ($strictMode == null ? 43 : ((Object)((Object)$strictMode)).hashCode());
        ScalarsMode $scalarsMode = this.getScalarsMode();
        result = result * 59 + ($scalarsMode == null ? 43 : ((Object)((Object)$scalarsMode)).hashCode());
        UniqueMode $uniqueMode = this.getUniqueMode();
        result = result * 59 + ($uniqueMode == null ? 43 : ((Object)((Object)$uniqueMode)).hashCode());
        WrapperMode $wrapperMode = this.getWrapperMode();
        result = result * 59 + ($wrapperMode == null ? 43 : ((Object)((Object)$wrapperMode)).hashCode());
        return result;
    }

    public static enum WrapperMode {
        WITHOUT_WRAPPER,
        WITHOUT_ARRAY_WRAPPER,
        WITH_WRAPPER,
        WITH_ARRAY_WRAPPER,
        WITH_UNCONDITIONAL_WRAPPER,
        WITH_CONDITIONAL_WRAPPER,
        WITH_UNCONDITIONAL_ARRAY_WRAPPER,
        WITH_CONDITIONAL_ARRAY_WRAPPER;

    }

    public static enum UniqueMode {
        WITH_UNIQUE_KEYS,
        WITHOUT_UNIQUE_KEYS;

    }

    public static enum ScalarsMode {
        ALLOW_SCALARS,
        DISALLOW_SCALARS;

    }

    public static enum StrictMode {
        LAX,
        STRICT;

    }
}

