/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.expression;

import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.expression.BaseExpression;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

public class RelationReference
extends BaseExpression {
    private final String relationName;
    private String userVariable;

    public RelationReference(@NonNull ParserRuleContext ctx, @NonNull String relationName) {
        super(ctx);
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (relationName == null) {
            throw new NullPointerException("relationName is marked non-null but is null");
        }
        this.relationName = relationName;
    }

    public RelationReference(@NonNull TerminalNode ctx, @NonNull String relationName) {
        super(ctx);
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (relationName == null) {
            throw new NullPointerException("relationName is marked non-null but is null");
        }
        this.relationName = relationName;
    }

    public RelationReference(@NonNull String relationName, Expression reference) {
        if (relationName == null) {
            throw new NullPointerException("relationName is marked non-null but is null");
        }
        this.relationName = relationName;
        if (reference != null) {
            this.reference(reference, Expression.ReferenceOperator.DOT);
        }
    }

    @Override
    public String doToString() {
        if (this.userVariable == null) {
            return this.relationName;
        }
        return this.relationName + this.userVariable;
    }

    public String getRelationName() {
        return this.relationName;
    }

    public String getUserVariable() {
        return this.userVariable;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelationReference)) {
            return false;
        }
        RelationReference other = (RelationReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$relationName = this.getRelationName();
        String other$relationName = other.getRelationName();
        if (this$relationName == null ? other$relationName != null : !this$relationName.equals(other$relationName)) {
            return false;
        }
        String this$userVariable = this.getUserVariable();
        String other$userVariable = other.getUserVariable();
        return !(this$userVariable == null ? other$userVariable != null : !this$userVariable.equals(other$userVariable));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RelationReference;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $relationName = this.getRelationName();
        result = result * 59 + ($relationName == null ? 43 : $relationName.hashCode());
        String $userVariable = this.getUserVariable();
        result = result * 59 + ($userVariable == null ? 43 : $userVariable.hashCode());
        return result;
    }

    public void setUserVariable(String userVariable) {
        this.userVariable = userVariable;
    }
}

