/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.insert;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.insert.InsertCondition;
import com.oceanbase.tools.sqlparser.statement.insert.InsertTable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class ConditionalInsert
extends BaseStatement {
    private List<InsertTable> elseClause = Collections.emptyList();
    private final List<InsertCondition> conditions;

    public ConditionalInsert(@NonNull ParserRuleContext context, @NonNull List<InsertCondition> conditions) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (conditions == null) {
            throw new NullPointerException("conditions is marked non-null but is null");
        }
        this.conditions = conditions;
    }

    public ConditionalInsert(@NonNull ParserRuleContext begin, @NonNull ParserRuleContext end, @NonNull List<InsertCondition> conditions) {
        super(begin, end);
        if (begin == null) {
            throw new NullPointerException("begin is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (conditions == null) {
            throw new NullPointerException("conditions is marked non-null but is null");
        }
        this.conditions = conditions;
    }

    public ConditionalInsert(@NonNull List<InsertCondition> conditions) {
        if (conditions == null) {
            throw new NullPointerException("conditions is marked non-null but is null");
        }
        this.conditions = conditions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.conditions.stream().map(InsertCondition::toString).collect(Collectors.joining("\n")));
        if (CollectionUtils.isNotEmpty(this.elseClause)) {
            builder.append("\nELSE\n\t").append(this.elseClause.stream().map(InsertTable::toString).collect(Collectors.joining("\n\t")));
        }
        return builder.toString();
    }

    public List<InsertTable> getElseClause() {
        return this.elseClause;
    }

    public List<InsertCondition> getConditions() {
        return this.conditions;
    }

    public void setElseClause(List<InsertTable> elseClause) {
        this.elseClause = elseClause;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionalInsert)) {
            return false;
        }
        ConditionalInsert other = (ConditionalInsert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<InsertTable> this$elseClause = this.getElseClause();
        List<InsertTable> other$elseClause = other.getElseClause();
        if (this$elseClause == null ? other$elseClause != null : !((Object)this$elseClause).equals(other$elseClause)) {
            return false;
        }
        List<InsertCondition> this$conditions = this.getConditions();
        List<InsertCondition> other$conditions = other.getConditions();
        return !(this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConditionalInsert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<InsertTable> $elseClause = this.getElseClause();
        result = result * 59 + ($elseClause == null ? 43 : ((Object)$elseClause).hashCode());
        List<InsertCondition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        return result;
    }
}

