/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.insert;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.oracle.LogErrors;
import com.oceanbase.tools.sqlparser.statement.common.oracle.Returning;
import com.oceanbase.tools.sqlparser.statement.insert.ConditionalInsert;
import com.oceanbase.tools.sqlparser.statement.insert.InsertTable;
import com.oceanbase.tools.sqlparser.statement.insert.mysql.SetColumn;
import com.oceanbase.tools.sqlparser.statement.select.Select;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;

public class Insert
extends BaseStatement {
    private Returning returning;
    private LogErrors logErrors;
    private Select select;
    private boolean all;
    private boolean first;
    private boolean replace;
    private boolean ignore;
    private boolean highPriority;
    private boolean lowPriority;
    private boolean overwrite;
    private List<SetColumn> onDuplicateKeyUpdateColumns;
    private final List<InsertTable> tableInsert;
    private final ConditionalInsert conditionalInsert;

    public Insert(@NonNull ParserRuleContext context, List<InsertTable> tableInsert, ConditionalInsert conditionalInsert) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        Validate.isTrue((CollectionUtils.isNotEmpty(tableInsert) || conditionalInsert != null ? 1 : 0) != 0);
        this.conditionalInsert = conditionalInsert;
        this.tableInsert = tableInsert == null ? Collections.emptyList() : tableInsert;
    }

    public Insert(@NonNull ParserRuleContext context, @NonNull Insert target) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.returning = target.returning;
        this.logErrors = target.logErrors;
        this.select = target.select;
        this.all = target.all;
        this.first = target.first;
        this.replace = target.replace;
        this.ignore = target.ignore;
        this.onDuplicateKeyUpdateColumns = target.onDuplicateKeyUpdateColumns;
        this.tableInsert = target.tableInsert;
        this.overwrite = target.overwrite;
        this.highPriority = target.highPriority;
        this.lowPriority = target.lowPriority;
        this.conditionalInsert = target.conditionalInsert;
    }

    public Insert(List<InsertTable> tableInsert, ConditionalInsert conditionalInsert) {
        Validate.isTrue((CollectionUtils.isNotEmpty(tableInsert) || conditionalInsert != null ? 1 : 0) != 0);
        this.conditionalInsert = conditionalInsert;
        this.tableInsert = tableInsert == null ? Collections.emptyList() : tableInsert;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.replace) {
            builder.append("REPLACE");
        } else {
            builder.append("INSERT");
        }
        if (this.highPriority) {
            builder.append(" HIGH_PRIORITY");
        } else if (this.lowPriority) {
            builder.append(" LOW_PRIORITY");
        }
        if (this.all) {
            builder.append(" ALL");
        } else if (this.first) {
            builder.append(" FIRST");
        } else if (this.ignore) {
            builder.append(" IGNORE");
        }
        if (this.overwrite) {
            builder.append(" OVERWRITE");
        }
        if (CollectionUtils.isNotEmpty(this.tableInsert)) {
            builder.append(" ").append(this.tableInsert.stream().map(InsertTable::toString).collect(Collectors.joining("\n")));
        } else if (this.conditionalInsert != null) {
            builder.append(" ").append(this.conditionalInsert);
        }
        if (this.select != null) {
            builder.append(" ").append(this.select);
        }
        if (this.returning != null) {
            builder.append(" ").append(this.returning);
        }
        if (this.logErrors != null) {
            builder.append(" ").append(this.logErrors);
        }
        if (CollectionUtils.isNotEmpty(this.onDuplicateKeyUpdateColumns)) {
            builder.append(" ON DUPLICATE KEY UPDATE ").append(this.onDuplicateKeyUpdateColumns.stream().map(SetColumn::toString).collect(Collectors.joining(",")));
        }
        return builder.toString();
    }

    public Returning getReturning() {
        return this.returning;
    }

    public LogErrors getLogErrors() {
        return this.logErrors;
    }

    public Select getSelect() {
        return this.select;
    }

    public boolean isAll() {
        return this.all;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public boolean isHighPriority() {
        return this.highPriority;
    }

    public boolean isLowPriority() {
        return this.lowPriority;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public List<SetColumn> getOnDuplicateKeyUpdateColumns() {
        return this.onDuplicateKeyUpdateColumns;
    }

    public List<InsertTable> getTableInsert() {
        return this.tableInsert;
    }

    public ConditionalInsert getConditionalInsert() {
        return this.conditionalInsert;
    }

    public void setReturning(Returning returning) {
        this.returning = returning;
    }

    public void setLogErrors(LogErrors logErrors) {
        this.logErrors = logErrors;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void setHighPriority(boolean highPriority) {
        this.highPriority = highPriority;
    }

    public void setLowPriority(boolean lowPriority) {
        this.lowPriority = lowPriority;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setOnDuplicateKeyUpdateColumns(List<SetColumn> onDuplicateKeyUpdateColumns) {
        this.onDuplicateKeyUpdateColumns = onDuplicateKeyUpdateColumns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Insert)) {
            return false;
        }
        Insert other = (Insert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Returning this$returning = this.getReturning();
        Returning other$returning = other.getReturning();
        if (this$returning == null ? other$returning != null : !((Object)this$returning).equals(other$returning)) {
            return false;
        }
        LogErrors this$logErrors = this.getLogErrors();
        LogErrors other$logErrors = other.getLogErrors();
        if (this$logErrors == null ? other$logErrors != null : !((Object)this$logErrors).equals(other$logErrors)) {
            return false;
        }
        Select this$select = this.getSelect();
        Select other$select = other.getSelect();
        if (this$select == null ? other$select != null : !((Object)this$select).equals(other$select)) {
            return false;
        }
        if (this.isAll() != other.isAll()) {
            return false;
        }
        if (this.isFirst() != other.isFirst()) {
            return false;
        }
        if (this.isReplace() != other.isReplace()) {
            return false;
        }
        if (this.isIgnore() != other.isIgnore()) {
            return false;
        }
        if (this.isHighPriority() != other.isHighPriority()) {
            return false;
        }
        if (this.isLowPriority() != other.isLowPriority()) {
            return false;
        }
        if (this.isOverwrite() != other.isOverwrite()) {
            return false;
        }
        List<SetColumn> this$onDuplicateKeyUpdateColumns = this.getOnDuplicateKeyUpdateColumns();
        List<SetColumn> other$onDuplicateKeyUpdateColumns = other.getOnDuplicateKeyUpdateColumns();
        if (this$onDuplicateKeyUpdateColumns == null ? other$onDuplicateKeyUpdateColumns != null : !((Object)this$onDuplicateKeyUpdateColumns).equals(other$onDuplicateKeyUpdateColumns)) {
            return false;
        }
        List<InsertTable> this$tableInsert = this.getTableInsert();
        List<InsertTable> other$tableInsert = other.getTableInsert();
        if (this$tableInsert == null ? other$tableInsert != null : !((Object)this$tableInsert).equals(other$tableInsert)) {
            return false;
        }
        ConditionalInsert this$conditionalInsert = this.getConditionalInsert();
        ConditionalInsert other$conditionalInsert = other.getConditionalInsert();
        return !(this$conditionalInsert == null ? other$conditionalInsert != null : !((Object)this$conditionalInsert).equals(other$conditionalInsert));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Insert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Returning $returning = this.getReturning();
        result = result * 59 + ($returning == null ? 43 : ((Object)$returning).hashCode());
        LogErrors $logErrors = this.getLogErrors();
        result = result * 59 + ($logErrors == null ? 43 : ((Object)$logErrors).hashCode());
        Select $select = this.getSelect();
        result = result * 59 + ($select == null ? 43 : ((Object)$select).hashCode());
        result = result * 59 + (this.isAll() ? 79 : 97);
        result = result * 59 + (this.isFirst() ? 79 : 97);
        result = result * 59 + (this.isReplace() ? 79 : 97);
        result = result * 59 + (this.isIgnore() ? 79 : 97);
        result = result * 59 + (this.isHighPriority() ? 79 : 97);
        result = result * 59 + (this.isLowPriority() ? 79 : 97);
        result = result * 59 + (this.isOverwrite() ? 79 : 97);
        List<SetColumn> $onDuplicateKeyUpdateColumns = this.getOnDuplicateKeyUpdateColumns();
        result = result * 59 + ($onDuplicateKeyUpdateColumns == null ? 43 : ((Object)$onDuplicateKeyUpdateColumns).hashCode());
        List<InsertTable> $tableInsert = this.getTableInsert();
        result = result * 59 + ($tableInsert == null ? 43 : ((Object)$tableInsert).hashCode());
        ConditionalInsert $conditionalInsert = this.getConditionalInsert();
        result = result * 59 + ($conditionalInsert == null ? 43 : ((Object)$conditionalInsert).hashCode());
        return result;
    }
}

