/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.select.FlashbackUsage;
import com.oceanbase.tools.sqlparser.statement.select.FromReference;
import com.oceanbase.tools.sqlparser.statement.select.oracle.Pivot;
import com.oceanbase.tools.sqlparser.statement.select.oracle.UnPivot;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class ExpressionReference
extends BaseStatement
implements FromReference {
    private final String alias;
    private final Expression target;
    private Pivot pivot;
    private UnPivot unPivot;
    private FlashbackUsage flashbackUsage;
    private boolean lateral;
    private List<String> aliasColumns;

    public ExpressionReference(@NonNull ParserRuleContext context, @NonNull Expression target, String alias) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.target = target;
        this.alias = alias;
    }

    public ExpressionReference(@NonNull Expression target, String alias) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.target = target;
        this.alias = alias;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.lateral) {
            builder.append("LATERAL ");
        }
        builder.append(this.target.toString());
        if (this.flashbackUsage != null) {
            builder.append(" ").append(this.flashbackUsage.toString());
        }
        if (this.pivot != null) {
            builder.append(" ").append(this.pivot.toString());
        }
        if (this.unPivot != null) {
            builder.append(" ").append(this.unPivot.toString());
        }
        if (this.alias != null) {
            builder.append(" ").append(this.alias);
        }
        if (CollectionUtils.isNotEmpty(this.aliasColumns)) {
            builder.append(" (").append(String.join((CharSequence)",", this.aliasColumns)).append(")");
        }
        return builder.toString();
    }

    public String getAlias() {
        return this.alias;
    }

    public Expression getTarget() {
        return this.target;
    }

    public Pivot getPivot() {
        return this.pivot;
    }

    public UnPivot getUnPivot() {
        return this.unPivot;
    }

    public FlashbackUsage getFlashbackUsage() {
        return this.flashbackUsage;
    }

    public boolean isLateral() {
        return this.lateral;
    }

    public List<String> getAliasColumns() {
        return this.aliasColumns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpressionReference)) {
            return false;
        }
        ExpressionReference other = (ExpressionReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        Expression this$target = this.getTarget();
        Expression other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        Pivot this$pivot = this.getPivot();
        Pivot other$pivot = other.getPivot();
        if (this$pivot == null ? other$pivot != null : !((Object)this$pivot).equals(other$pivot)) {
            return false;
        }
        UnPivot this$unPivot = this.getUnPivot();
        UnPivot other$unPivot = other.getUnPivot();
        if (this$unPivot == null ? other$unPivot != null : !((Object)this$unPivot).equals(other$unPivot)) {
            return false;
        }
        FlashbackUsage this$flashbackUsage = this.getFlashbackUsage();
        FlashbackUsage other$flashbackUsage = other.getFlashbackUsage();
        if (this$flashbackUsage == null ? other$flashbackUsage != null : !((Object)this$flashbackUsage).equals(other$flashbackUsage)) {
            return false;
        }
        if (this.isLateral() != other.isLateral()) {
            return false;
        }
        List<String> this$aliasColumns = this.getAliasColumns();
        List<String> other$aliasColumns = other.getAliasColumns();
        return !(this$aliasColumns == null ? other$aliasColumns != null : !((Object)this$aliasColumns).equals(other$aliasColumns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExpressionReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        Expression $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        Pivot $pivot = this.getPivot();
        result = result * 59 + ($pivot == null ? 43 : ((Object)$pivot).hashCode());
        UnPivot $unPivot = this.getUnPivot();
        result = result * 59 + ($unPivot == null ? 43 : ((Object)$unPivot).hashCode());
        FlashbackUsage $flashbackUsage = this.getFlashbackUsage();
        result = result * 59 + ($flashbackUsage == null ? 43 : ((Object)$flashbackUsage).hashCode());
        result = result * 59 + (this.isLateral() ? 79 : 97);
        List<String> $aliasColumns = this.getAliasColumns();
        result = result * 59 + ($aliasColumns == null ? 43 : ((Object)$aliasColumns).hashCode());
        return result;
    }

    public void setPivot(Pivot pivot) {
        this.pivot = pivot;
    }

    public void setUnPivot(UnPivot unPivot) {
        this.unPivot = unPivot;
    }

    public void setFlashbackUsage(FlashbackUsage flashbackUsage) {
        this.flashbackUsage = flashbackUsage;
    }

    public void setLateral(boolean lateral) {
        this.lateral = lateral;
    }

    public void setAliasColumns(List<String> aliasColumns) {
        this.aliasColumns = aliasColumns;
    }
}

