/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.select.PartitionType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class PartitionUsage
extends BaseStatement {
    private final PartitionType type;
    private final List<String> nameList;
    private final Map<String, Expression> externalTablePartition;

    public PartitionUsage(@NonNull ParserRuleContext context, PartitionType type, @NonNull List<String> nameList) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (nameList == null) {
            throw new NullPointerException("nameList is marked non-null but is null");
        }
        this.type = type;
        this.nameList = nameList;
        this.externalTablePartition = null;
    }

    public PartitionUsage(PartitionType type, @NonNull List<String> nameList) {
        if (nameList == null) {
            throw new NullPointerException("nameList is marked non-null but is null");
        }
        this.type = type;
        this.nameList = nameList;
        this.externalTablePartition = null;
    }

    public PartitionUsage(@NonNull ParserRuleContext context, PartitionType type, @NonNull Map<String, Expression> externalTablePartition) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (externalTablePartition == null) {
            throw new NullPointerException("externalTablePartition is marked non-null but is null");
        }
        this.type = type;
        this.nameList = null;
        this.externalTablePartition = externalTablePartition;
    }

    public PartitionUsage(PartitionType type, @NonNull Map<String, Expression> externalTablePartition) {
        if (externalTablePartition == null) {
            throw new NullPointerException("externalTablePartition is marked non-null but is null");
        }
        this.type = type;
        this.nameList = null;
        this.externalTablePartition = externalTablePartition;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.type == PartitionType.PARTITION) {
            buffer.append("PARTITION ");
        } else {
            buffer.append("SUBPARTITION ");
        }
        if (this.nameList != null) {
            return buffer.append("(").append(String.join((CharSequence)",", this.nameList)).append(")").toString();
        }
        return buffer.append("(").append(this.externalTablePartition.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining(", "))).append(")").toString();
    }

    public PartitionType getType() {
        return this.type;
    }

    public List<String> getNameList() {
        return this.nameList;
    }

    public Map<String, Expression> getExternalTablePartition() {
        return this.externalTablePartition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartitionUsage)) {
            return false;
        }
        PartitionUsage other = (PartitionUsage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PartitionType this$type = this.getType();
        PartitionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<String> this$nameList = this.getNameList();
        List<String> other$nameList = other.getNameList();
        if (this$nameList == null ? other$nameList != null : !((Object)this$nameList).equals(other$nameList)) {
            return false;
        }
        Map<String, Expression> this$externalTablePartition = this.getExternalTablePartition();
        Map<String, Expression> other$externalTablePartition = other.getExternalTablePartition();
        return !(this$externalTablePartition == null ? other$externalTablePartition != null : !((Object)this$externalTablePartition).equals(other$externalTablePartition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartitionUsage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartitionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<String> $nameList = this.getNameList();
        result = result * 59 + ($nameList == null ? 43 : ((Object)$nameList).hashCode());
        Map<String, Expression> $externalTablePartition = this.getExternalTablePartition();
        result = result * 59 + ($externalTablePartition == null ? 43 : ((Object)$externalTablePartition).hashCode());
        return result;
    }
}

