/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

public class Projection
extends BaseStatement {
    private final Expression column;
    private final String columnLabel;
    private final boolean star;

    public Projection(@NonNull ParserRuleContext ruleContext, @NonNull Expression column, String columnLabel) {
        super(ruleContext);
        if (ruleContext == null) {
            throw new NullPointerException("ruleContext is marked non-null but is null");
        }
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        this.column = column;
        this.columnLabel = columnLabel;
        this.star = false;
    }

    public Projection(@NonNull TerminalNode terminalNode) {
        super(terminalNode);
        if (terminalNode == null) {
            throw new NullPointerException("terminalNode is marked non-null but is null");
        }
        this.column = null;
        this.columnLabel = null;
        this.star = true;
    }

    public Projection(@NonNull Expression column, String columnLabel) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        this.column = column;
        this.columnLabel = columnLabel;
        this.star = false;
    }

    public Projection() {
        this.column = null;
        this.columnLabel = null;
        this.star = true;
    }

    public String toString() {
        if (this.star) {
            return "*";
        }
        StringBuilder builder = new StringBuilder();
        if (this.column != null) {
            builder.append(this.column.toString());
        }
        if (this.columnLabel != null) {
            builder.append(" AS ").append(this.columnLabel);
        }
        return builder.toString();
    }

    public Expression getColumn() {
        return this.column;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public boolean isStar() {
        return this.star;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Projection)) {
            return false;
        }
        Projection other = (Projection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$column = this.getColumn();
        Expression other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        String this$columnLabel = this.getColumnLabel();
        String other$columnLabel = other.getColumnLabel();
        if (this$columnLabel == null ? other$columnLabel != null : !this$columnLabel.equals(other$columnLabel)) {
            return false;
        }
        return this.isStar() == other.isStar();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Projection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        String $columnLabel = this.getColumnLabel();
        result = result * 59 + ($columnLabel == null ? 43 : $columnLabel.hashCode());
        result = result * 59 + (this.isStar() ? 79 : 97);
        return result;
    }
}

