/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.select.GroupBy;
import com.oceanbase.tools.sqlparser.statement.select.SortDirection;
import com.oceanbase.tools.sqlparser.statement.select.oracle.SortNullPosition;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class SortKey
extends BaseStatement
implements GroupBy {
    private final Expression sort;
    private final SortDirection direction;
    private final SortNullPosition nullPosition;

    public SortKey(@NonNull ParserRuleContext context, @NonNull Expression sort, SortDirection direction, SortNullPosition nullPosition) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (sort == null) {
            throw new NullPointerException("sort is marked non-null but is null");
        }
        this.sort = sort;
        this.direction = direction;
        this.nullPosition = nullPosition;
    }

    public SortKey(@NonNull ParserRuleContext context, @NonNull Expression sort, SortDirection direction) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (sort == null) {
            throw new NullPointerException("sort is marked non-null but is null");
        }
        this.nullPosition = null;
        this.sort = sort;
        this.direction = direction;
    }

    public SortKey(@NonNull Expression sort, SortDirection direction) {
        if (sort == null) {
            throw new NullPointerException("sort is marked non-null but is null");
        }
        this.nullPosition = null;
        this.sort = sort;
        this.direction = direction;
    }

    public SortKey(@NonNull Expression sort, SortDirection direction, SortNullPosition nullPosition) {
        if (sort == null) {
            throw new NullPointerException("sort is marked non-null but is null");
        }
        this.sort = sort;
        this.direction = direction;
        this.nullPosition = nullPosition;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.sort.toString());
        if (this.direction != null) {
            builder.append(" ").append(this.direction.name());
        }
        if (this.nullPosition != null) {
            builder.append(" ").append("NULLS ").append(this.nullPosition == SortNullPosition.LAST ? "LAST" : "FIRST");
        }
        return builder.toString();
    }

    public Expression getSort() {
        return this.sort;
    }

    public SortDirection getDirection() {
        return this.direction;
    }

    public SortNullPosition getNullPosition() {
        return this.nullPosition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortKey)) {
            return false;
        }
        SortKey other = (SortKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$sort = this.getSort();
        Expression other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !this$sort.equals(other$sort)) {
            return false;
        }
        SortDirection this$direction = this.getDirection();
        SortDirection other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
            return false;
        }
        SortNullPosition this$nullPosition = this.getNullPosition();
        SortNullPosition other$nullPosition = other.getNullPosition();
        return !(this$nullPosition == null ? other$nullPosition != null : !((Object)((Object)this$nullPosition)).equals((Object)other$nullPosition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SortKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
        SortDirection $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
        SortNullPosition $nullPosition = this.getNullPosition();
        result = result * 59 + ($nullPosition == null ? 43 : ((Object)((Object)$nullPosition)).hashCode());
        return result;
    }
}

