/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select.oracle;

import com.oceanbase.tools.sqlparser.statement.expression.BaseExpression;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class XmlNamespaces
extends BaseExpression {
    private final List<XmlNamespace> namespaces;

    public XmlNamespaces(@NonNull ParserRuleContext context, @NonNull List<XmlNamespace> namespaces) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (namespaces == null) {
            throw new NullPointerException("namespaces is marked non-null but is null");
        }
        this.namespaces = namespaces;
    }

    public XmlNamespaces(@NonNull List<XmlNamespace> namespaces) {
        if (namespaces == null) {
            throw new NullPointerException("namespaces is marked non-null but is null");
        }
        this.namespaces = namespaces;
    }

    @Override
    protected String doToString() {
        return "XMLNAMESPACES(" + this.namespaces.stream().map(BaseExpression::toString).collect(Collectors.joining(",")) + ")";
    }

    public static class XmlNamespace
    extends BaseExpression {
        private boolean defaultValue;
        private String alias;
        private final String value;

        public XmlNamespace(@NonNull ParserRuleContext context, @NonNull String value) {
            super(context);
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
        }

        public XmlNamespace(@NonNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
        }

        @Override
        protected String doToString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.defaultValue) {
                stringBuilder.append("DEFAULT ");
            }
            stringBuilder.append(this.value);
            if (this.alias != null) {
                stringBuilder.append(" AS ").append(this.alias);
            }
            return stringBuilder.toString();
        }

        public boolean isDefaultValue() {
            return this.defaultValue;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getValue() {
            return this.value;
        }

        public void setDefaultValue(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }
    }
}

