/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.antlr.exception;

import com.alipay.oceanbase.antlr.exception.EErrorInfo;

public class EException
extends RuntimeException {
    public static final int FEATURE_GROUP = 1;
    public static final int GRAMMAR_GROUP = 2;
    public static final int PROGRAM_GROUP = 3;
    public static final int CREATE_TABLE_SELECT = 1;
    public static final int DATA_TYPE_RESOLVE = 2;
    public static final int DATA_PRECISION_OVERFLOW = 3;
    public static final int GENERATE_DATA_TYPE = 4;
    public static final int USER_DEFINE_DATA_TYPE = 5;
    public static final int NOT_SUPPORT_DATA_TYPE = 6;
    public static final int INCOMPATIBLE_DATA_TYPE_CONVERT = 7;
    public static final int UNEXPECTED_TYPE = 8;
    public static final int INVALID_INPUT = 9;
    public static final int PARTITION_LOST_RANGE = 10;
    public static final int NOT_SUPPORTED_FEATURE = 11;
    public static final int UNSUPPORTED_GRAMMAR = 2048;
    public static final int OBJECT_NULL_ERROR = 4096;
    public static final int INVALID_ARGUMENT = 4097;
    public static final int NOT_IMPL_ERROR = 4098;
    public static final int QUERY_REMOTE_ERROR = 4099;
    public static final int WRAPPED_ERROR = 4100;
    private final EErrorInfo errorInfo;

    public EException(String message, int errorCode, int errGroup) {
        super(message);
        this.errorInfo = new EErrorInfo(errGroup, errorCode, message);
    }

    public EException(String message, int errorCode, int errGroup, Throwable e) {
        super(message, e);
        this.errorInfo = new EErrorInfo(errGroup, errorCode, message);
    }

    public static EException buildUnsupportedFeatureException(String message, int errorCode) {
        return new EException(message, errorCode, 1);
    }

    public static EException buildUnsupportedFeatureException(String message) {
        return new EException(message, 11, 1);
    }

    public static EException buildUnsupportedDataTypeException(String message) {
        return new EException(message, 6, 1);
    }

    public static EException buildUnsupportedGrammarException(String message, int errorCode) {
        return new EException(message, errorCode, 2);
    }

    public static EException buildProgramException(String message, int errorCode) {
        return new EException(message, errorCode, 3);
    }

    public static EException buildWrappedException(Throwable e) {
        return new EException(e.getMessage(), 4100, 3);
    }
}

