/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.antlr.mysql;

import com.alipay.oceanbase.antlr.exception.EException;
import com.alipay.oceanbase.antlr.mysql.MySQLSymbolInfo;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.atn.LexerATNSimulator;
import org.apache.commons.lang.StringUtils;

public abstract class MySQLBaseLexer
extends Lexer {
    public Set<String> charsets = new HashSet<String>();
    protected boolean inVersionComment;
    protected int sqlMode;
    protected long serverVersion;
    private final Deque<Token> _pendingTokens;

    public MySQLBaseLexer(CharStream input) {
        super(input);
        this.charsets.add("_utf8mb4");
        this.charsets.add("_utf8mb3");
        this._pendingTokens = new LinkedList<Token>();
        this.serverVersion = 80000L;
        this.sqlMode = 0;
        this.inVersionComment = false;
    }

    public MySQLBaseLexer(CharStream input, long version) {
        super(input);
        this.charsets.add("_utf8mb4");
        this.charsets.add("_utf8mb3");
        this._pendingTokens = new LinkedList<Token>();
        this.serverVersion = version != 0L ? version : 80000L;
        this.sqlMode = 0;
        this.inVersionComment = false;
    }

    public void setVersion(long version) {
        if (MySQLSymbolInfo.numberToVersion(version) == MySQLSymbolInfo.MySQLVersion.Unknown) {
            throw EException.buildProgramException("invalid mysql version: " + version, 4097);
        }
        this.serverVersion = version;
    }

    public long getServerVersion() {
        return this.serverVersion;
    }

    public void reset() {
        this.inVersionComment = false;
        super.reset();
    }

    public final boolean isIdentifier(int type) {
        if (type == 819 || type == 821) {
            return true;
        }
        if (this.isSqlModeActive(1) && type == 822) {
            return true;
        }
        String symbol = this.getVocabulary().getSymbolicName(type);
        MySQLSymbolInfo.MySQLVersion version = MySQLSymbolInfo.numberToVersion(this.serverVersion);
        return !StringUtils.isEmpty((String)symbol) && !MySQLSymbolInfo.isReservedKeyword(symbol, version);
    }

    public static boolean isNumber(int type) {
        switch (type) {
            case 747: 
            case 748: 
            case 749: 
            case 788: 
            case 789: 
            case 790: 
            case 791: {
                return true;
            }
        }
        return false;
    }

    public static boolean isOperator(int type) {
        switch (type) {
            case 750: 
            case 751: 
            case 752: 
            case 753: 
            case 754: 
            case 755: 
            case 756: 
            case 757: 
            case 758: 
            case 759: 
            case 760: 
            case 761: 
            case 762: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 769: 
            case 770: 
            case 771: 
            case 772: 
            case 773: 
            case 774: 
            case 775: 
            case 776: 
            case 777: 
            case 783: 
            case 785: 
            case 787: 
            case 830: {
                return true;
            }
        }
        return false;
    }

    public Token nextToken() {
        if (!this._pendingTokens.isEmpty()) {
            return this._pendingTokens.poll();
        }
        Token next = super.nextToken();
        if (!this._pendingTokens.isEmpty()) {
            this._pendingTokens.offer(next);
            return this._pendingTokens.poll();
        }
        return next;
    }

    protected boolean checkVersion(String text) {
        if (text.length() < 8) {
            return false;
        }
        long version = Long.parseLong(text.substring(3, 8));
        if (version <= this.serverVersion) {
            this.inVersionComment = true;
            return true;
        }
        return false;
    }

    protected int determineFunction(int proposed) {
        if (this.isSqlModeActive(8)) {
            int input = this._input.LA(1);
            while (input == 32 || input == 9 || input == 13 || input == 10) {
                ((LexerATNSimulator)this.getInterpreter()).consume(this._input);
                this._channel = 1;
                this._type = 816;
                input = this._input.LA(1);
            }
        }
        return this._input.LA(1) == 40 ? proposed : 819;
    }

    protected int determineNumericType(String text) {
        int bigger;
        int smaller;
        String cmp;
        String longString = "2147483647";
        String signedLongString = "-2147483648";
        String longLongString = "9223372036854775807";
        String signedLongLongString = "-9223372036854775808";
        String unsignedLongLongString = "18446744073709551615";
        int length = text.length();
        if (length < "2147483647".length()) {
            return 747;
        }
        boolean negative = false;
        int idx = 0;
        if (text.charAt(idx) == '+') {
            ++idx;
            --length;
        } else if (text.charAt(idx) == '-') {
            ++idx;
            --length;
            negative = true;
        }
        while (text.charAt(idx) == '0' && length != 0) {
            ++idx;
            --length;
        }
        if (length < "2147483647".length()) {
            return 747;
        }
        if (negative) {
            if (length == "2147483647".length()) {
                cmp = "-2147483648".substring(1);
                smaller = 747;
                bigger = 748;
            } else {
                if (length < "-9223372036854775808".length()) {
                    return 748;
                }
                if (length > "-9223372036854775808".length()) {
                    return 790;
                }
                cmp = "-9223372036854775808".substring(1);
                smaller = 748;
                bigger = 790;
            }
        } else if (length == "2147483647".length()) {
            cmp = "2147483647";
            smaller = 747;
            bigger = 748;
        } else {
            if (length < "9223372036854775807".length()) {
                return 748;
            }
            if (length > "9223372036854775807".length()) {
                if (length > "18446744073709551615".length()) {
                    return 790;
                }
                cmp = "18446744073709551615";
                smaller = 749;
                bigger = 790;
            } else {
                cmp = "9223372036854775807";
                smaller = 748;
                bigger = 749;
            }
        }
        int cmpIdx = 0;
        while (cmpIdx < cmp.length() && cmp.charAt(cmpIdx) == text.charAt(idx)) {
            ++cmpIdx;
            ++idx;
        }
        if (cmpIdx != 0) {
            --cmpIdx;
            --idx;
        }
        return text.charAt(idx) <= cmp.charAt(cmpIdx) ? smaller : bigger;
    }

    protected int checkCharset(String text) {
        return this.charsets.contains(text) ? 818 : 819;
    }

    protected void emitDot() {
        Token token = this._factory.create(this._tokenFactorySourcePair, 772, this._text, this._channel, this._tokenStartCharIndex, this._tokenStartCharIndex, this._tokenStartLine, this._tokenStartCharPositionInLine);
        this._pendingTokens.offer(token);
        ++this._tokenStartCharIndex;
    }

    protected boolean isSqlModeActive(int mode) {
        return (this.sqlMode & mode) != 0;
    }
}

