/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.antlr.mysql;

import com.alipay.oceanbase.antlr.mysql.KeywordList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MySQLSymbolInfo {
    private static Map<MySQLVersion, Set<String>> keywords = new HashMap<MySQLVersion, Set<String>>();
    private static Map<MySQLVersion, Set<String>> reservedKeywords = new HashMap<MySQLVersion, Set<String>>();
    public static final long MYSQL_56_VERSION = 56000L;
    public static final long MYSQL_57_VERSION = 57000L;
    public static final long MYSQL_80_VERSION = 80000L;

    public static boolean isReservedKeyword(String identifier, MySQLVersion version) {
        MySQLSymbolInfo.keywordsForVersion(version);
        return reservedKeywords.containsKey(identifier);
    }

    public static MySQLVersion numberToVersion(long version) {
        long major = version / 10000L;
        long minor = version / 100L % 100L;
        if (major < 5L || major > 8L) {
            return MySQLVersion.Unknown;
        }
        if (major == 8L) {
            return MySQLVersion.MySQL80;
        }
        if (major != 5L) {
            return MySQLVersion.Unknown;
        }
        switch ((int)minor) {
            case 6: {
                return MySQLVersion.MySQL56;
            }
            case 7: {
                return MySQLVersion.MySQL57;
            }
        }
        return MySQLVersion.Unknown;
    }

    private static Set<String> keywordsForVersion(MySQLVersion version) {
        if (!keywords.containsKey((Object)version)) {
            HashSet<String> keywordSet = new HashSet<String>();
            HashSet<String> reservedKeywordSet = new HashSet<String>();
            KeywordList.Keyword[] keywordList = new KeywordList.Keyword[]{};
            switch (version) {
                case MySQL56: {
                    keywordList = KeywordList.KEY_WORD_LIST_56;
                    break;
                }
                case MySQL57: {
                    keywordList = KeywordList.KEY_WORD_LIST_57;
                    break;
                }
                case MySQL80: {
                    keywordList = KeywordList.KEY_WORD_LIST_80;
                    break;
                }
            }
            for (int i = 0; i < keywordList.length; ++i) {
                String word = keywordList[i].word;
                keywordSet.add(word);
                if (!keywordList[i].reserved) continue;
                reservedKeywordSet.add(word);
            }
            keywords.put(version, keywordSet);
        }
        return keywords.get((Object)version);
    }

    static enum MySQLVersion {
        Unknown,
        MySQL56,
        MySQL57,
        MySQL80;

    }
}

