/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.antlr.oboracle;

import com.alipay.oceanbase.antlr.g4.base.listener.PLSQLErrorListener;
import com.alipay.oceanbase.antlr.g4.base.strategy.PLErrorStrategy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATN;

public abstract class PlBaseParser
extends Parser {
    private static final int whiteSpace = 32;

    public PlBaseParser(TokenStream input) {
        super(input);
    }

    public void ForwardSQL(ParserRuleContext ctx, String exprName) {
        this.doForward(ctx, exprName, "forward_sql_stmt", false);
    }

    public void ForwardExpr(ParserRuleContext ctx, String exprName) {
        this.doForward(ctx, exprName, "forward_expr", true);
    }

    private void doForward(ParserRuleContext ctx, String exprName, String entrypoint, boolean isExpr) {
        String text = this._input.getText(ctx.start, this._input.LT(-1));
        text = this.addMoreLAT(text, exprName);
        CodePointCharStream cs = CharStreams.fromString((String)text);
        PLSQLErrorListener lexerErrorListener = new PLSQLErrorListener();
        PLSQLErrorListener parserErrorListener = new PLSQLErrorListener();
        Lexer lexer = this.getLexer((CharStream)cs);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)lexerErrorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        tokens.fill();
        Parser parser = this.getOBParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)parserErrorListener);
        parser.setErrorHandler((ANTLRErrorStrategy)new PLErrorStrategy());
        try {
            PlBaseParser.setValue(parser, "is_pl_parse_", true);
            PlBaseParser.setValue(parser, "is_pl_parse_expr_", isExpr);
            while (ctx.getChildCount() != 0) {
                ctx.removeLastChild();
            }
            ctx.addChild((RuleContext)PlBaseParser.doInvoke(parser, entrypoint));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String addMoreLAT(String text, String exprName) {
        boolean isBreak;
        int leftParenCount = 0;
        int rightParenCount = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean inEscape = false;
        boolean inComment = false;
        boolean isComment = false;
        int length = text.toCharArray().length;
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (!(inComment || isComment || c != '-' || i + 2 >= length || text.charAt(i + 1) != '-' || text.charAt(i + 2) != ' ' || inSingleQuote || inDoubleQuote)) {
                inComment = true;
                i += 2;
                continue;
            }
            if (inComment) {
                if (c != '\r' && c != '\n') continue;
                inComment = false;
                continue;
            }
            if (!(isComment || c != '/' || i + 1 >= length || text.charAt(i + 1) != '*' || inDoubleQuote || inSingleQuote)) {
                isComment = true;
                ++i;
                continue;
            }
            if (isComment) {
                if (c != '/' || text.charAt(i - 1) != '*') continue;
                isComment = false;
                continue;
            }
            if (inEscape) {
                inEscape = false;
                continue;
            }
            if (c == '\\' && !inDoubleQuote && !inSingleQuote) {
                inEscape = true;
                continue;
            }
            if (c == '\'' && !inDoubleQuote) {
                boolean bl = inSingleQuote = !inSingleQuote;
            }
            if (c == '\"' && !inSingleQuote) {
                boolean bl = inDoubleQuote = !inDoubleQuote;
            }
            if (!inSingleQuote && !inDoubleQuote && c == '(') {
                ++leftParenCount;
                continue;
            }
            if (inSingleQuote || inDoubleQuote || c != ')') continue;
            ++rightParenCount;
        }
        Set endTokens = this.getExpr2endTokens().get(exprName);
        boolean bl = isBreak = leftParenCount == rightParenCount;
        while (!isBreak) {
            int _la = this._input.LA(1);
            if (_la == -1) {
                isBreak = true;
                break;
            }
            if (leftParenCount == rightParenCount && endTokens.contains(_la)) {
                isBreak = true;
                break;
            }
            if (_la == this.getLeftParen()) {
                ++leftParenCount;
            } else if (_la == this.getRightParen()) {
                ++rightParenCount;
            }
            text = text + this._input.LT(1).getText();
            this._errHandler.reportMatch((Parser)this);
            this.consume();
        }
        return text;
    }

    public String[] getTokenNames() {
        return new String[0];
    }

    public String[] getRuleNames() {
        return new String[0];
    }

    public String getGrammarFileName() {
        return null;
    }

    public ATN getATN() {
        return null;
    }

    private static Object doInvoke(Parser parser, String entrypoint) throws Exception {
        Class<?> clazz = parser.getClass();
        String clazzName = clazz.getName();
        Method method = clazz.getMethod(entrypoint, new Class[0]);
        if (method == null) {
            throw new IllegalAccessException(String.format("The method %s() is undefined in the class %s", entrypoint, clazzName));
        }
        return method.invoke((Object)parser, new Object[0]);
    }

    private static void setValue(Parser parser, String field, Object value) throws Exception {
        Class<?> clazz = parser.getClass();
        Field declaredField = clazz.getDeclaredField(field);
        declaredField.set(parser, value);
    }

    public abstract Lexer getLexer(CharStream var1);

    public abstract Parser getOBParser(CommonTokenStream var1);

    public abstract int getRightParen();

    public abstract int getLeftParen();

    public abstract Map<String, HashSet<Integer>> getExpr2endTokens();
}

