/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.exception.FeatureNotSupportedException;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.table.AbstractTableBatchOps;
import com.alipay.oceanbase.rpc.table.ObTableClientBatchOpsImpl;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class ObClusterTableBatchOps
extends AbstractTableBatchOps {
    private final ObTableClientBatchOpsImpl tableBatchOps;

    ObClusterTableBatchOps(ObTableClientBatchOpsImpl tableBatchOps) {
        this.tableBatchOps = tableBatchOps;
    }

    ObClusterTableBatchOps(ExecutorService executorService, ObTableClientBatchOpsImpl tableBatchOps) {
        this.tableBatchOps = tableBatchOps;
        this.tableBatchOps.setExecutorService(executorService);
    }

    @Override
    public void get(Object[] rowkeys, String[] columns) {
        this.tableBatchOps.get(rowkeys, columns);
    }

    @Override
    public void update(Object[] rowkeys, String[] columns, Object[] values) {
        this.tableBatchOps.update(rowkeys, columns, values);
    }

    @Override
    public void delete(Object[] rowkeys) {
        this.tableBatchOps.delete(rowkeys);
    }

    @Override
    public void insert(Object[] rowkeys, String[] columns, Object[] values) {
        this.tableBatchOps.insert(rowkeys, columns, values);
    }

    @Override
    public void replace(Object[] rowkeys, String[] columns, Object[] values) {
        this.tableBatchOps.replace(rowkeys, columns, values);
    }

    @Override
    public void insertOrUpdate(Object[] rowkeys, String[] columns, Object[] values) {
        this.tableBatchOps.insertOrUpdate(rowkeys, columns, values);
    }

    @Override
    public void increment(Object[] rowkeys, String[] columns, Object[] values, boolean withResult) {
        this.tableBatchOps.increment(rowkeys, columns, values, withResult);
    }

    @Override
    public void append(Object[] rowkeys, String[] columns, Object[] values, boolean withResult) {
        this.tableBatchOps.append(rowkeys, columns, values, withResult);
    }

    @Override
    public void put(Object[] rowkeys, String[] columns, Object[] values) {
        this.tableBatchOps.put(rowkeys, columns, values);
    }

    @Override
    public List<Object> execute() throws Exception {
        this.preCheck();
        return this.tableBatchOps.execute();
    }

    @Override
    public List<Object> executeWithResult() throws Exception {
        this.preCheck();
        return this.tableBatchOps.executeWithResult();
    }

    public ObTableBatchOperationResult executeInternal() throws Exception {
        this.preCheck();
        return this.tableBatchOps.executeInternal();
    }

    @Override
    public void clear() {
        this.tableBatchOps.clear();
    }

    @Override
    public ObTableBatchOperation getObTableBatchOperation() {
        return this.tableBatchOps.getObTableBatchOperation();
    }

    @Override
    public String getTableName() {
        return this.tableBatchOps.getTableName();
    }

    @Override
    public void setEntityType(ObTableEntityType entityType) {
        super.setEntityType(entityType);
        this.tableBatchOps.setEntityType(entityType);
    }

    @Override
    public void setAtomicOperation(boolean atomicOperation) {
        super.setAtomicOperation(atomicOperation);
        this.tableBatchOps.setAtomicOperation(atomicOperation);
    }

    @Override
    public void setReturnOneResult(boolean returnOneResult) {
        super.setReturnOneResult(returnOneResult);
        this.tableBatchOps.setReturnOneResult(returnOneResult);
    }

    void preCheck() {
        List<ObTableOperation> operations = this.tableBatchOps.getObTableBatchOperation().getTableOperations();
        if (operations.isEmpty()) {
            throw new IllegalArgumentException("operations is empty");
        }
        ObTableOperationType lastType = operations.get(0).getOperationType();
        if (this.returnOneResult && !ObGlobal.isReturnOneResultSupport()) {
            throw new FeatureNotSupportedException("returnOneResult is not supported in this Observer version [" + ObGlobal.obVsnString() + "]");
        }
        if (this.returnOneResult && (!this.tableBatchOps.getObTableBatchOperation().isSameType() || lastType != ObTableOperationType.INSERT && lastType != ObTableOperationType.PUT && lastType != ObTableOperationType.REPLACE && lastType != ObTableOperationType.DEL)) {
            throw new IllegalArgumentException("returnOneResult only support multi-insert/put/replace/del");
        }
    }
}

