/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.bolt.transport;

import com.alipay.oceanbase.rpc.bolt.protocol.ObTablePacket;
import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.InvokeFuture;
import com.alipay.remoting.RemotingCommand;
import io.netty.util.Timeout;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ObClientFuture
implements InvokeFuture {
    private CountDownLatch waiter = new CountDownLatch(1);
    private RemotingCommand response;
    private int channelId;
    private static int INIT = 0;
    private static int BY_WORKER = 1;
    private static int BY_BACKGROUND = 2;
    private AtomicInteger releaseFlag = new AtomicInteger(INIT);

    public ObClientFuture(int channelId) {
        this.channelId = channelId;
    }

    public RemotingCommand waitResponse(long timeoutMillis) throws InterruptedException {
        block6: {
            if (!this.waiter.await(timeoutMillis, TimeUnit.MILLISECONDS) && this.releaseFlag.compareAndSet(INIT, BY_BACKGROUND)) break block6;
            RemotingCommand remotingCommand = this.response;
            return remotingCommand;
        }
        try {
            RemotingCommand remotingCommand = null;
            return remotingCommand;
        }
        catch (InterruptedException e) {
            this.releaseFlag.set(BY_BACKGROUND);
            if (this.response instanceof ObTablePacket) {
                ((ObTablePacket)this.response).releaseByteBuf();
            }
            throw e;
        }
    }

    public RemotingCommand waitResponse() throws InterruptedException {
        this.waiter.await();
        return this.response;
    }

    public void putResponse(RemotingCommand response) {
        this.response = response;
        this.waiter.countDown();
        if (!this.releaseFlag.compareAndSet(INIT, BY_WORKER) && response instanceof ObTablePacket) {
            ((ObTablePacket)response).releaseByteBuf();
        }
    }

    public int invokeId() {
        return this.channelId;
    }

    public boolean isDone() {
        return this.waiter.getCount() == 0L;
    }

    public RemotingCommand createConnectionClosedResponse(InetSocketAddress responseHost) {
        return null;
    }

    public void executeInvokeCallback() {
    }

    public void tryAsyncExecuteInvokeCallbackAbnormally() {
    }

    public void setCause(Throwable cause) {
    }

    public Throwable getCause() {
        return null;
    }

    public InvokeCallback getInvokeCallback() {
        return null;
    }

    public void addTimeout(Timeout timeout) {
    }

    public void cancelTimeout() {
    }

    public ClassLoader getAppClassLoader() {
        return null;
    }

    public byte getProtocolCode() {
        return 0;
    }

    public void setInvokeContext(InvokeContext invokeContext) {
    }

    public InvokeContext getInvokeContext() {
        return null;
    }
}

