/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.bolt.transport;

import com.alipay.oceanbase.rpc.bolt.protocol.ObTableProtocol;
import com.alipay.oceanbase.rpc.bolt.transport.ObConfigurableInstance;
import com.alipay.oceanbase.rpc.bolt.transport.ObPacketCodec;
import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventHandler;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.NamedThreadFactory;
import com.alipay.remoting.ProtocolCode;
import com.alipay.remoting.Url;
import com.alipay.remoting.codec.Codec;
import com.alipay.remoting.config.ConfigManager;
import com.alipay.remoting.config.ConfigurableInstance;
import com.alipay.remoting.connection.AbstractConnectionFactory;
import com.alipay.remoting.connection.ConnectionFactory;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.rpc.RpcHandler;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.remoting.util.NettyEventLoopUtil;
import com.alipay.remoting.util.StringUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;

public class ObConnectionFactory
implements ConnectionFactory {
    private static final Logger logger = BoltLoggerFactory.getLogger(AbstractConnectionFactory.class);
    private static final EventLoopGroup workerGroup = NettyEventLoopUtil.newEventLoopGroup((int)(Runtime.getRuntime().availableProcessors() + 1), (ThreadFactory)new NamedThreadFactory("Rpc-netty-client-worker", true));
    private final ConfigurableInstance confInstance;
    private final Codec codec;
    private final ChannelHandler handler;
    protected Bootstrap bootstrap;

    private ObConnectionFactory(Codec codec, ChannelHandler handler, ConfigurableInstance confInstance) {
        if (codec == null) {
            throw new IllegalArgumentException("null codec");
        }
        if (handler == null) {
            throw new IllegalArgumentException("null handler");
        }
        this.confInstance = confInstance;
        this.codec = codec;
        this.handler = handler;
    }

    public void init(final ConnectionEventHandler connectionEventHandler) {
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(workerGroup)).channel(NettyEventLoopUtil.getClientSocketChannelClass())).option(ChannelOption.TCP_NODELAY, (Object)ConfigManager.tcp_nodelay())).option(ChannelOption.SO_REUSEADDR, (Object)ConfigManager.tcp_so_reuseaddr())).option(ChannelOption.SO_KEEPALIVE, (Object)ConfigManager.tcp_so_keepalive());
        this.initWriteBufferWaterMark();
        if (ConfigManager.netty_buffer_pooled()) {
            this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        } else {
            this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT);
        }
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast("decoder", ObConnectionFactory.this.codec.newDecoder());
                pipeline.addLast("encoder", ObConnectionFactory.this.codec.newEncoder());
                pipeline.addLast("connectionEventHandler", (ChannelHandler)connectionEventHandler);
                pipeline.addLast("handler", ObConnectionFactory.this.handler);
            }
        });
    }

    public Connection createConnection(Url url) throws Exception {
        throw new IllegalArgumentException("not support yet");
    }

    public Connection createConnection(String targetIP, int targetPort, int connectTimeout) throws Exception {
        Channel channel = this.doCreateConnection(targetIP, targetPort, connectTimeout);
        Connection conn = new Connection(channel, ProtocolCode.fromBytes((byte[])ObTableProtocol.MAGIC_HEADER_FLAG), 1, new Url(targetIP, targetPort));
        channel.pipeline().fireUserEventTriggered((Object)ConnectionEventType.CONNECT);
        return conn;
    }

    public Connection createConnection(String targetIP, int targetPort, byte version, int connectTimeout) throws Exception {
        throw new IllegalArgumentException("not support yet");
    }

    protected Channel doCreateConnection(String targetIP, int targetPort, int connectTimeout) throws Exception {
        connectTimeout = Math.max(connectTimeout, 1000);
        String address = targetIP + ":" + targetPort;
        if (logger.isDebugEnabled()) {
            logger.debug("connectTimeout of address [{}] is [{}].", (Object)address, (Object)connectTimeout);
        }
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout);
        ChannelFuture future = this.bootstrap.connect((SocketAddress)new InetSocketAddress(targetIP, targetPort));
        if (!future.await((long)(connectTimeout + 10))) {
            String errMsg = "Create connection to " + address + " future await timeout!";
            logger.warn(errMsg);
            boolean isCanceled = future.cancel(false);
            logger.warn("Create connection future canceled: {}", (Object)isCanceled);
            throw new Exception(errMsg, future.cause());
        }
        if (!future.isDone()) {
            String errMsg = "Create connection to " + address + " timeout!";
            logger.warn(errMsg);
            throw new Exception(errMsg);
        }
        if (future.isCancelled()) {
            String errMsg = "Create connection to " + address + " cancelled by user!";
            logger.warn(errMsg);
            throw new Exception(errMsg);
        }
        if (!future.isSuccess()) {
            String errMsg = "Create connection to " + address + " error!";
            logger.warn(errMsg);
            throw new Exception(errMsg, future.cause());
        }
        return future.channel();
    }

    private void initWriteBufferWaterMark() {
        int highWaterMark;
        int lowWaterMark = this.confInstance.netty_buffer_low_watermark();
        if (lowWaterMark > (highWaterMark = this.confInstance.netty_buffer_high_watermark())) {
            throw new IllegalArgumentException(String.format("[client side] bolt netty high water mark {%s} should not be smaller than low water mark {%s} bytes)", highWaterMark, lowWaterMark));
        }
        logger.warn("[client side] bolt netty low water mark is {} bytes, high water mark is {} bytes", (Object)lowWaterMark, (Object)highWaterMark);
        this.bootstrap.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(lowWaterMark, highWaterMark));
    }

    public static ObConnectionFactoryBuilder newBuilder() {
        return new ObConnectionFactoryBuilder();
    }

    public static class ObConnectionFactoryBuilder {
        private Codec codec = new ObPacketCodec();
        private ConcurrentHashMap<String, UserProcessor<?>> userProcessors = new ConcurrentHashMap(4);
        private ChannelHandler rpcHandler = new RpcHandler(this.userProcessors);
        private ConfigurableInstance configurableInstance = new ObConfigurableInstance();

        public ObConnectionFactoryBuilder registerUserProcessor(UserProcessor<?> processor) {
            if (processor == null || StringUtils.isBlank((CharSequence)processor.interest())) {
                throw new RuntimeException("User processor or processor interest should not be blank!");
            }
            UserProcessor<?> preProcessor = this.userProcessors.putIfAbsent(processor.interest(), processor);
            if (preProcessor != null) {
                String errMsg = "Processor with interest key [" + processor.interest() + "] has already been registered to rpc client, can not register again!";
                throw new RuntimeException(errMsg);
            }
            return this;
        }

        public ObConnectionFactoryBuilder configWriteBufferWaterMark(int low, int high) {
            this.configurableInstance.initWriteBufferWaterMark(low, high);
            return this;
        }

        public ObConnectionFactory build() {
            return new ObConnectionFactory(this.codec, this.rpcHandler, this.configurableInstance);
        }
    }
}

