/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.bolt.transport;

import com.alibaba.fastjson.JSONObject;
import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.exception.ObTableAuthException;
import com.alipay.oceanbase.rpc.exception.ObTableConnectionStatusException;
import com.alipay.oceanbase.rpc.exception.ObTableConnectionUnWritableException;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTableLoginException;
import com.alipay.oceanbase.rpc.exception.ObTableServerConnectException;
import com.alipay.oceanbase.rpc.location.LocationUtil;
import com.alipay.oceanbase.rpc.protocol.payload.impl.login.ObTableLoginRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.login.ObTableLoginResult;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import com.alipay.oceanbase.rpc.util.Security;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import com.alipay.oceanbase.rpc.util.TraceUtil;
import com.alipay.remoting.Connection;
import java.net.ConnectException;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class ObTableConnection {
    private static final Logger LOGGER = TableClientLoggerFactory.getLogger(ObTableConnection.class);
    private ObBytesString credential;
    private long tenantId = 1L;
    private Connection connection;
    private final ObTable obTable;
    private long uniqueId;
    private AtomicLong sequence;
    private AtomicBoolean isReConnecting = new AtomicBoolean(false);
    private AtomicBoolean isExpired = new AtomicBoolean(false);
    private LocalDateTime lastConnectionTime;
    private boolean loginWithConfigs = false;

    public static long ipToLong(String strIp) {
        String[] ip = strIp.split("\\.");
        return (Long.parseLong(ip[0]) << 24) + (Long.parseLong(ip[1]) << 16) + (Long.parseLong(ip[2]) << 8) + Long.parseLong(ip[3]);
    }

    public boolean checkExpired() {
        long maxConnectionTimes = this.obTable.getConnMaxExpiredTime();
        return this.lastConnectionTime.isBefore(LocalDateTime.now().minusMinutes(maxConnectionTimes));
    }

    public boolean isExpired() {
        return this.isExpired.get();
    }

    public void setExpired(boolean expired) {
        this.isExpired.set(expired);
    }

    public void enableLoginWithConfigs() {
        this.loginWithConfigs = true;
    }

    public ObTableConnection(ObTable obTable) {
        this.obTable = obTable;
    }

    public void init() throws Exception {
        this.sequence = new AtomicLong();
        this.connect();
    }

    private boolean connect() throws Exception {
        int tries;
        if (this.checkAvailable()) {
            return false;
        }
        long start = System.currentTimeMillis();
        Exception cause = null;
        int maxTryTimes = this.obTable.getObTableConnectTryTimes();
        for (tries = 0; tries < maxTryTimes; ++tries) {
            try {
                this.connection = this.obTable.getConnectionFactory().createConnection(this.obTable.getIp(), this.obTable.getPort(), this.obTable.getObTableConnectTimeout());
                break;
            }
            catch (Exception e) {
                cause = e;
                LOGGER.warn("connect failed at " + tries + " try " + TraceUtil.formatIpPort(this.obTable), (Throwable)e);
                continue;
            }
        }
        String endpoint = this.obTable.getIp() + ":" + this.obTable.getPort();
        TableClientLoggerFactory.MONITOR.info(this.logMessage(null, "CONNECT", endpoint, System.currentTimeMillis() - start));
        if (tries >= maxTryTimes) {
            LOGGER.warn("connect failed after max " + maxTryTimes + " tries " + TraceUtil.formatIpPort(this.obTable));
            throw new ObTableServerConnectException("connect failed after max " + maxTryTimes + " tries " + TraceUtil.formatIpPort(this.obTable), cause);
        }
        try {
            long ip = ObTableConnection.ipToLong(this.connection.getLocalIP());
            long port = (long)this.connection.getLocalPort() << 32;
            long isUserRequest = 0x1000000000000L;
            long reserved = 0L;
            this.uniqueId = ip | port | isUserRequest | reserved;
            this.login();
            this.lastConnectionTime = LocalDateTime.now();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        return true;
    }

    private void login() throws Exception {
        int tries;
        long start = System.currentTimeMillis();
        ObTableLoginRequest request = new ObTableLoginRequest();
        request.setTenantName(this.obTable.getTenantName());
        request.setUserName(this.obTable.getUserName());
        request.setDatabaseName(this.obTable.getDatabase());
        if (this.loginWithConfigs && !this.obTable.getConfigs().isEmpty()) {
            JSONObject json = new JSONObject(this.obTable.getConfigs());
            request.setConfigsStr(json.toJSONString());
            this.loginWithConfigs = false;
        }
        this.generatePassSecret(request);
        Exception cause = null;
        int maxTryTimes = this.obTable.getObTableLoginTryTimes();
        for (tries = 0; tries < maxTryTimes; ++tries) {
            try {
                ObTableLoginResult result = (ObTableLoginResult)this.obTable.getRealClient().invokeSync(this, request, this.obTable.getObTableLoginTimeout());
                if (result == null || result.getCredential() == null || result.getCredential().length() <= 0) continue;
                this.credential = result.getCredential();
                this.tenantId = result.getTenantId();
                if (ObGlobal.obVsnMajor() != 0 || result.getServerVersion().isEmpty()) break;
                LocationUtil.parseObVerionFromLogin(result.getServerVersion());
                LOGGER.info("The OB_VERSION parsed from login result is: {}", (Object)ObGlobal.OB_VERSION);
                break;
            }
            catch (Exception e) {
                cause = e;
                String errMessage = "login failed at " + tries + " try " + TraceUtil.formatIpPort(this.obTable);
                LOGGER.warn(errMessage, (Throwable)e);
                if (!(e instanceof ObTableAuthException)) continue;
                throw new ObTableLoginException(errMessage, e);
            }
        }
        String endpoint = this.obTable.getIp() + ":" + this.obTable.getPort();
        TableClientLoggerFactory.MONITOR.info(this.logMessage(TraceUtil.formatTraceMessage(request), "LOGIN", endpoint, System.currentTimeMillis() - start));
        if (tries >= maxTryTimes) {
            LOGGER.warn("login failed after max " + maxTryTimes + " tries " + TraceUtil.formatIpPort(this.obTable));
            throw new ObTableServerConnectException("login failed after max " + maxTryTimes + " tries " + TraceUtil.formatIpPort(this.obTable), cause);
        }
    }

    public void close() {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
            this.credential = null;
        }
    }

    public void checkStatus() throws Exception {
        if (this.connection == null) {
            this.reconnect("Check connection is null");
        }
        if (this.connection.getChannel() == null || !this.connection.getChannel().isActive()) {
            this.reconnect("Check connection failed for address: " + this.connection.getUrl());
        }
        if (!this.connection.getChannel().isWritable()) {
            LOGGER.warn("The connection might be write overflow : " + this.connection.getUrl());
            Thread.sleep(this.obTable.getNettyBlockingWaitInterval());
            if (!this.connection.getChannel().isWritable()) {
                throw new ObTableConnectionUnWritableException("Check connection failed for address: " + this.connection.getUrl() + ", maybe write overflow!");
            }
        }
    }

    public void reConnectAndLogin(String msg) throws ObTableException {
        try {
            if (this.checkAvailable()) {
                LOGGER.warn("The connection would be closed and reconnected if: " + this.connection.getUrl());
                this.close();
            }
            this.reconnect(msg);
        }
        catch (ConnectException ex) {
            throw new ObTableServerConnectException(ex);
        }
        catch (ObTableServerConnectException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ObTableConnectionStatusException("check status failed", ex);
        }
    }

    private void reconnect(String msg) throws Exception {
        if (this.isReConnecting.compareAndSet(false, true)) {
            try {
                if (this.connect()) {
                    LOGGER.warn("reconnect success. reconnect reason: [{}]", (Object)msg);
                }
                LOGGER.info("connection maybe reconnect by other thread. reconnect reason: [{}]", (Object)msg);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (!this.isReConnecting.compareAndSet(true, false)) {
                    LOGGER.error("failed to set connecting to false after connect finished, reconnect reason: [{}]", (Object)msg);
                }
            }
        } else {
            LOGGER.warn("There is someone connecting, no need reconnect");
            throw new ObTableException("This connection is already Connecting");
        }
    }

    public ObBytesString getCredential() {
        return this.credential;
    }

    public void setCredential(ObBytesString credential) {
        this.credential = credential;
    }

    public long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ObTable getObTable() {
        return this.obTable;
    }

    private boolean checkAvailable() {
        if (this.connection == null) {
            return false;
        }
        if (this.connection.getChannel() == null) {
            return false;
        }
        if (!this.connection.getChannel().isActive()) {
            return false;
        }
        return this.credential != null;
    }

    private void generatePassSecret(ObTableLoginRequest request) {
        ObBytesString scramble = Security.getPasswordScramble(20);
        request.setPassSecret(Security.scramblePassword(this.obTable.getPassword().getBytes(), scramble.bytes));
        request.setPassScramble(scramble);
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public long getNextSequence() {
        return this.sequence.incrementAndGet();
    }

    private String logMessage(String traceId, String methodName, String endpoint, long executeTime) {
        if (StringUtils.isNotBlank((String)endpoint)) {
            endpoint = endpoint.replaceAll(",", "#");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (traceId != null) {
            stringBuilder.append(traceId).append(" - ");
        }
        stringBuilder.append(methodName).append(",").append(endpoint).append(",").append(executeTime);
        return stringBuilder.toString();
    }
}

