/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadConnectionFactory;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadLogger;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadStatement;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadTraceId;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadExceptionUtil;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadIllegalArgumentException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadIllegalStateException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadTimeoutException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadUnexpectedException;
import com.alipay.oceanbase.rpc.direct_load.protocol.ObDirectLoadProtocol;
import com.alipay.oceanbase.rpc.direct_load.protocol.ObDirectLoadProtocolFactory;
import com.alipay.oceanbase.rpc.direct_load.protocol.ObDirectLoadRpc;
import com.alipay.oceanbase.rpc.direct_load.util.ObDirectLoadUtil;
import com.alipay.oceanbase.rpc.property.Property;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.table.ObTable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class ObDirectLoadConnection {
    private final ObDirectLoadConnectionFactory connectionFactory;
    private final ObDirectLoadTraceId traceId;
    private final ObDirectLoadLogger logger;
    private String ip = null;
    private int port = 0;
    private String tenantName = null;
    private String userName = null;
    private String password = null;
    private String databaseName = null;
    private int writeConnectionNum = 0;
    private long heartBeatTimeout = 0L;
    private long heartBeatInterval = 0L;
    private boolean isInited = false;
    private boolean isClosed = false;
    private ObDirectLoadProtocol protocol = null;
    private LinkedList<ObDirectLoadStatement> statementList = null;

    ObDirectLoadConnection(ObDirectLoadConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.traceId = ObDirectLoadTraceId.generateTraceId();
        this.logger = ObDirectLoadLogger.getLogger(this.traceId);
    }

    public ObDirectLoadTraceId getTraceId() {
        return this.traceId;
    }

    public ObDirectLoadLogger getLogger() {
        return this.logger;
    }

    public synchronized void init(Builder builder) throws ObDirectLoadException {
        if (this.isInited) {
            this.logger.warn("init twice, connection:" + this);
            throw new ObDirectLoadIllegalStateException("init twice, connection:" + this);
        }
        if (this.isClosed) {
            this.logger.warn("already closed, connection:" + this);
            throw new ObDirectLoadIllegalStateException("already closed, connection:" + this);
        }
        this.fillParams(builder);
        this.initCheck();
        this.initProtocol();
        this.statementList = new LinkedList();
        this.isInited = true;
        this.logger.info("connection init successful, args:" + builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.logger.info("connection close");
        ObDirectLoadStatement[] statements = null;
        ObDirectLoadStatement[] obDirectLoadStatementArray = this;
        synchronized (this) {
            if (this.isClosed) {
                this.logger.info("connection is closed");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.isClosed = true;
            statements = this.statementList.toArray(new ObDirectLoadStatement[0]);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (statements.length > 0) {
                this.logger.info("connection close wait statements close, size:" + statements.length);
                for (ObDirectLoadStatement statement : statements) {
                    statement.close();
                }
            }
            this.logger.info("connection close successful");
            this.connectionFactory.closeConnection((ObDirectLoadConnection)this);
            return;
        }
    }

    public void checkStatus() throws ObDirectLoadException {
        if (!this.isInited) {
            throw new ObDirectLoadIllegalStateException("connection not init");
        }
        if (this.isClosed) {
            throw new ObDirectLoadIllegalStateException("connection is closed");
        }
    }

    private void fillParams(Builder builder) throws ObDirectLoadException {
        if (builder == null) {
            this.logger.warn("builder cannot be null");
            throw new ObDirectLoadIllegalArgumentException("builder cannot be null");
        }
        this.ip = builder.ip;
        this.port = builder.port;
        this.tenantName = builder.tenantName;
        this.userName = builder.userName;
        this.password = builder.password;
        this.databaseName = builder.databaseName;
        this.heartBeatTimeout = builder.heartBeatTimeout;
        this.heartBeatInterval = builder.heartBeatInterval;
        this.writeConnectionNum = builder.writeConnectionNum;
    }

    private void initCheck() throws ObDirectLoadException {
        ObDirectLoadUtil.checkNonEmpty(this.ip, "ip", this.logger);
        ObDirectLoadUtil.checkInRange(this.port, 1, 65535, "port", this.logger);
        ObDirectLoadUtil.checkNonEmpty(this.tenantName, "tenantName", this.logger);
        ObDirectLoadUtil.checkNonEmpty(this.userName, "userName", this.logger);
        ObDirectLoadUtil.checkNotNull(this.password, "password", this.logger);
        ObDirectLoadUtil.checkNonEmpty(this.databaseName, "databaseName", this.logger);
        ObDirectLoadUtil.checkPositive(this.writeConnectionNum, "writeConnectionNum", this.logger);
        if (this.heartBeatTimeout < 3000L) {
            this.logger.warn("Param 'heartBeatTimeout' must not be less than 3000 ms, value:" + this.heartBeatTimeout);
            throw new ObDirectLoadIllegalArgumentException("Param 'heartBeatTimeout' must not be less than 3000 ms, value:" + this.heartBeatTimeout);
        }
        if (this.heartBeatInterval < 100L) {
            this.logger.warn("Param 'heartBeatInterval' must not be less than 1 ms, value:" + this.heartBeatInterval);
            throw new ObDirectLoadIllegalArgumentException("Param 'heartBeatInterval' must not be less than 1 ms, value:" + this.heartBeatInterval);
        }
        if (this.heartBeatTimeout <= this.heartBeatInterval) {
            this.logger.warn("Param 'heartBeatInterval' must not be greater than or equal to Param 'heartBeatTimeout', heartBeatTimeout:" + this.heartBeatTimeout + ", heartBeatInterval:" + this.heartBeatInterval);
            throw new ObDirectLoadIllegalArgumentException("Param 'heartBeatInterval' must not be greater than or equal to Param 'heartBeatTimeout', heartBeatTimeout:" + this.heartBeatTimeout + ", heartBeatInterval:" + this.heartBeatInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProtocol() throws ObDirectLoadException {
        ObTable table = null;
        ObDirectLoadConnectionFactory obDirectLoadConnectionFactory = this.connectionFactory;
        synchronized (obDirectLoadConnectionFactory) {
            ObGlobal.OB_VERSION = 0L;
            try {
                Properties properties = new Properties();
                properties.setProperty(Property.SERVER_CONNECTION_POOL_SIZE.getKey(), String.valueOf(1));
                table = new ObTable.Builder(this.ip, this.port).setLoginInfo(this.tenantName, this.userName, this.password, this.databaseName).setProperties(properties).build();
            }
            catch (Exception e) {
                throw new ObDirectLoadException(e);
            }
        }
        this.protocol = ObDirectLoadProtocolFactory.getProtocol(this.traceId, ObGlobal.OB_VERSION);
        this.protocol.init();
        table.close();
    }

    public ObDirectLoadProtocol getProtocol() {
        return this.protocol;
    }

    public long getHeartBeatTimeout() {
        return this.heartBeatTimeout;
    }

    public long getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public String toString() {
        return String.format("{ip:\"%s\", port:%d, tenantName:\"%s\", userName:\"%s\", databaseName:\"%s\", writeConnectionNum:%d}", this.ip, this.port, this.tenantName, this.userName, this.databaseName, this.writeConnectionNum);
    }

    public void executeWithConnection(ObDirectLoadRpc rpc, ObTable table, long timeoutMillis) throws ObDirectLoadException {
        try {
            rpc.setRpcTimeout(timeoutMillis);
            ObPayload request = rpc.getRequest();
            ObPayload result = table.execute(request);
            rpc.setResult(result);
        }
        catch (Exception e) {
            throw ObDirectLoadExceptionUtil.convertException(e);
        }
    }

    public synchronized ObDirectLoadStatement createStatement() throws ObDirectLoadException {
        if (!this.isInited) {
            this.logger.warn("connection not init");
            throw new ObDirectLoadIllegalStateException("connection not init");
        }
        if (this.isClosed) {
            this.logger.warn("connection is closed");
            throw new ObDirectLoadIllegalStateException("connection is closed");
        }
        ObDirectLoadStatement stmt = new ObDirectLoadStatement(this);
        this.statementList.addLast(stmt);
        return stmt;
    }

    public synchronized void closeStatement(ObDirectLoadStatement stmt) {
        this.statementList.remove(stmt);
    }

    public ObDirectLoadStatement.Builder getStatementBuilder() {
        return new ObDirectLoadStatement.Builder(this);
    }

    ObDirectLoadStatement buildStatement(ObDirectLoadStatement.Builder builder) throws ObDirectLoadException {
        ObDirectLoadStatement stmt = null;
        try {
            stmt = this.createStatement();
            stmt.init(builder);
        }
        catch (Exception e) {
            this.logger.warn("build statement failed, args:" + builder, e);
            this.closeStatement(stmt);
            throw e;
        }
        return stmt;
    }

    public static final class ObTablePool {
        private static final int highPrioConnectionIdx = 0;
        private static final int controlConnectionIdx = 1;
        private static final int writeConnectionStartIdx = 2;
        private final ObDirectLoadConnection connection;
        private final ObDirectLoadLogger logger;
        private final long timeoutMillis;
        private ObTable[] tables;
        private BlockingQueue<ObTable> availableWriteObTableQueue = null;
        private int availableWriteObTableNum = 0;
        private boolean isInited = false;
        private boolean isClosed = false;

        ObTablePool(ObDirectLoadConnection connection, ObDirectLoadLogger logger, long timeoutMillis) {
            this.connection = connection;
            this.logger = logger;
            this.timeoutMillis = timeoutMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() throws ObDirectLoadException {
            ObDirectLoadConnectionFactory obDirectLoadConnectionFactory = this.connection.connectionFactory;
            synchronized (obDirectLoadConnectionFactory) {
                this.initTables();
            }
            this.initAvailableWriteObTableQueue();
            this.isInited = true;
        }

        public void close() {
            if (this.tables != null) {
                for (int i = 0; i < this.tables.length; ++i) {
                    ObTable table = this.tables[i];
                    if (table == null) continue;
                    table.close();
                }
            }
            this.tables = null;
            this.isClosed = true;
        }

        private void initTables() throws ObDirectLoadException {
            int poolSize = 2 + this.connection.writeConnectionNum;
            Properties properties = new Properties();
            properties.setProperty(Property.SERVER_CONNECTION_POOL_SIZE.getKey(), String.valueOf(1));
            properties.setProperty(Property.RPC_EXECUTE_TIMEOUT.getKey(), String.valueOf(this.timeoutMillis));
            properties.setProperty(Property.RPC_OPERATION_TIMEOUT.getKey(), String.valueOf(this.timeoutMillis));
            properties.setProperty(Property.SERVER_ENABLE_REROUTING.getKey(), String.valueOf(false));
            this.tables = new ObTable[poolSize];
            try {
                for (int i = 0; i < this.tables.length; ++i) {
                    this.tables[i] = new ObTable.Builder(this.connection.ip, this.connection.port).setLoginInfo(this.connection.tenantName, this.connection.userName, this.connection.password, this.connection.databaseName).setProperties(properties).build();
                }
            }
            catch (Exception e) {
                throw new ObDirectLoadException(e);
            }
        }

        private void initAvailableWriteObTableQueue() throws ObDirectLoadException {
            this.availableWriteObTableQueue = new ArrayBlockingQueue<ObTable>(this.connection.writeConnectionNum);
            try {
                for (int i = 0; i < this.connection.writeConnectionNum; ++i) {
                    ObTable table = this.tables[2 + i];
                    this.availableWriteObTableQueue.put(table);
                }
                this.availableWriteObTableNum = this.connection.writeConnectionNum;
            }
            catch (Exception e) {
                throw new ObDirectLoadException(e);
            }
        }

        public ObTable getHighPrioObTable() throws ObDirectLoadException {
            if (!this.isInited) {
                this.logger.warn("ob table pool not init");
                throw new ObDirectLoadIllegalStateException("ob table pool not init");
            }
            if (this.isClosed) {
                this.logger.warn("ob table pool is closed");
                throw new ObDirectLoadIllegalStateException("ob table pool is closed");
            }
            return this.tables[0];
        }

        public ObTable getControlObTable() throws ObDirectLoadException {
            if (!this.isInited) {
                this.logger.warn("ob table pool not init");
                throw new ObDirectLoadIllegalStateException("ob table pool not init");
            }
            if (this.isClosed) {
                this.logger.warn("ob table pool is closed");
                throw new ObDirectLoadIllegalStateException("ob table pool is closed");
            }
            return this.tables[1];
        }

        public ObTable takeWriteObTable(long timeoutMillis) throws ObDirectLoadException {
            if (!this.isInited) {
                this.logger.warn("ob table pool not init");
                throw new ObDirectLoadIllegalStateException("ob table pool not init");
            }
            try {
                long startTime = System.currentTimeMillis();
                ObTable table = null;
                while (table == null) {
                    if (this.isClosed) {
                        this.logger.warn("ob table pool is closed");
                        throw new ObDirectLoadIllegalStateException("ob table pool is closed");
                    }
                    if (this.availableWriteObTableNum == 0) {
                        this.logger.warn("ob table pool no avaiable write ob table");
                        throw new ObDirectLoadUnexpectedException("ob table pool no avaiable write ob table");
                    }
                    if (startTime + timeoutMillis < System.currentTimeMillis()) {
                        this.logger.warn("ob table pool task write ob table timeout");
                        throw new ObDirectLoadTimeoutException("ob table pool task write ob table timeout");
                    }
                    table = this.availableWriteObTableQueue.poll(1000L, TimeUnit.MILLISECONDS);
                }
                return table;
            }
            catch (Exception e) {
                this.logger.warn("ob table pool task write ob table failed", e);
                throw ObDirectLoadExceptionUtil.convertException(e);
            }
        }

        public void putWriteObTable(ObTable table) {
            try {
                this.availableWriteObTableQueue.put(table);
            }
            catch (Exception e) {
                --this.availableWriteObTableNum;
                this.logger.warn("ob table pool put write ob table failed, availableWriteObTableNum:" + this.availableWriteObTableNum, e);
            }
        }
    }

    public static final class Builder {
        private ObDirectLoadConnectionFactory connectionFactory = null;
        private String ip = null;
        private int port = 0;
        private String tenantName = null;
        private String userName = null;
        private String password = null;
        private String databaseName = null;
        private int writeConnectionNum = 1;
        private long heartBeatTimeout = 60000L;
        private long heartBeatInterval = 10000L;
        private static final long MAX_HEART_BEAT_TIMEOUT = 31536000000L;

        Builder(ObDirectLoadConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        public Builder setServerInfo(String ip, int port) {
            this.ip = ip;
            this.port = port;
            return this;
        }

        public Builder setLoginInfo(String tenantName, String userName, String password, String databaseName) {
            this.tenantName = tenantName;
            this.userName = userName;
            this.password = password;
            this.databaseName = databaseName;
            return this;
        }

        public Builder enableParallelWrite(int writeParallel) {
            this.writeConnectionNum = writeParallel;
            return this;
        }

        public Builder setHeartBeatInfo(long heartBeatTimeout, long heartBeatInterval) {
            this.heartBeatTimeout = Math.min(heartBeatTimeout, 31536000000L);
            this.heartBeatInterval = heartBeatInterval;
            return this;
        }

        public String toString() {
            return String.format("{ip:\"%s\", port:%d, tenantName:\"%s\", userName:\"%s\", databaseName:\"%s\", writeConnectionNum:%d, heartBeatTimeout:%d, heartBeatInterval:%d}", this.ip, this.port, this.tenantName, this.userName, this.databaseName, this.writeConnectionNum, this.heartBeatTimeout, this.heartBeatInterval);
        }

        public ObDirectLoadConnection build() throws ObDirectLoadException {
            return this.connectionFactory.buildConnection(this);
        }
    }
}

