/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load;

import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadBucket;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadConnection;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadLogger;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadTraceId;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadIllegalArgumentException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadIllegalStateException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadTimeoutException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadUnexpectedException;
import com.alipay.oceanbase.rpc.direct_load.execution.ObDirectLoadStatementExecutionId;
import com.alipay.oceanbase.rpc.direct_load.execution.ObDirectLoadStatementExecutor;
import com.alipay.oceanbase.rpc.direct_load.future.ObDirectLoadStatementFailedFuture;
import com.alipay.oceanbase.rpc.direct_load.future.ObDirectLoadStatementFuture;
import com.alipay.oceanbase.rpc.direct_load.util.ObDirectLoadUtil;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObLoadDupActionType;
import java.util.Arrays;

public class ObDirectLoadStatement {
    private final ObDirectLoadConnection connection;
    private final ObDirectLoadTraceId traceId;
    private final ObDirectLoadLogger logger;
    private String tableName = null;
    private String[] columnNames = null;
    private String[] partitionNames = null;
    private ObLoadDupActionType dupAction = ObLoadDupActionType.INVALID_MODE;
    private int parallel = 0;
    private long queryTimeout = 0L;
    private long maxErrorRowCount = 0L;
    private String loadMethod = "";
    private boolean isInited = false;
    private boolean isClosed = false;
    private ObDirectLoadConnection.ObTablePool obTablePool = null;
    private ObDirectLoadStatementExecutor executor = null;
    private long startQueryTimeMillis = 0L;

    ObDirectLoadStatement(ObDirectLoadConnection connection) {
        this.connection = connection;
        this.traceId = ObDirectLoadTraceId.generateTraceId();
        this.logger = ObDirectLoadLogger.getLogger(this.traceId);
    }

    public ObDirectLoadConnection getConnection() {
        return this.connection;
    }

    public ObDirectLoadTraceId getTraceId() {
        return this.traceId;
    }

    public ObDirectLoadLogger getLogger() {
        return this.logger;
    }

    public synchronized void init(Builder builder) throws ObDirectLoadException {
        if (this.isInited) {
            this.logger.warn("statement init twice");
            throw new ObDirectLoadIllegalStateException("statement init twice");
        }
        if (this.isClosed) {
            this.logger.warn("statement is closed");
            throw new ObDirectLoadIllegalStateException("statement is closed");
        }
        this.fillParams(builder);
        this.initCheck();
        this.connection.getProtocol().checkIsSupported(this);
        this.obTablePool = new ObDirectLoadConnection.ObTablePool(this.connection, this.logger, this.queryTimeout);
        this.obTablePool.init();
        this.executor = new ObDirectLoadStatementExecutor(this);
        this.startQueryTimeMillis = System.currentTimeMillis();
        this.isInited = true;
        this.logger.info("statement init successful, args:" + builder);
    }

    public synchronized void close() {
        this.logger.info("statement close");
        if (this.isClosed) {
            this.logger.info("statement is closed");
            return;
        }
        this.isClosed = true;
        if (this.executor != null) {
            this.executor.close();
            this.executor = null;
        }
        if (this.obTablePool != null) {
            this.obTablePool.close();
            this.obTablePool = null;
        }
        this.logger.info("statement close successful");
        this.connection.closeStatement(this);
    }

    private void fillParams(Builder builder) throws ObDirectLoadException {
        if (builder == null) {
            this.logger.warn("builder cannot be null");
            throw new ObDirectLoadIllegalArgumentException("builder cannot be null");
        }
        this.tableName = builder.tableName;
        this.columnNames = builder.columnNames;
        this.partitionNames = builder.partitionNames;
        this.dupAction = builder.dupAction;
        this.parallel = builder.parallel;
        this.queryTimeout = builder.queryTimeout;
        this.maxErrorRowCount = builder.maxErrorRowCount;
        this.loadMethod = builder.loadMethod;
        if (this.loadMethod.compareToIgnoreCase("inc_replace") == 0) {
            this.dupAction = ObLoadDupActionType.STOP_ON_DUP;
        }
    }

    private void initCheck() throws ObDirectLoadException {
        ObDirectLoadUtil.checkNonEmpty(this.tableName, "tableName", this.logger);
        if (this.columnNames == null) {
            this.columnNames = new String[0];
        } else {
            ObDirectLoadUtil.checkNonEmptyAndUnique(this.columnNames, "columnNames", this.logger);
        }
        if (this.partitionNames == null) {
            this.partitionNames = new String[0];
        } else {
            ObDirectLoadUtil.checkNonEmptyAndUnique(this.partitionNames, "partitionNames", this.logger);
        }
        ObDirectLoadUtil.checkNonValid(this.dupAction, ObLoadDupActionType.INVALID_MODE, "dupAction", this.logger);
        ObDirectLoadUtil.checkPositive(this.parallel, "parallel", this.logger);
        ObDirectLoadUtil.checkPositive(this.queryTimeout, "queryTimeout", this.logger);
        ObDirectLoadUtil.checkPositiveOrZero(this.maxErrorRowCount, "maxErrorRowCount", this.logger);
        ObDirectLoadUtil.checkNonEmpty(this.loadMethod, "loadMethod", this.logger);
    }

    public void checkStatus() throws ObDirectLoadException {
        if (!this.isInited) {
            this.logger.warn("statement not init");
            throw new ObDirectLoadIllegalStateException("statement not init");
        }
        if (this.isClosed) {
            this.logger.warn("statement is closed");
            throw new ObDirectLoadIllegalStateException("statement is closed");
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getPartitionNames() {
        return this.partitionNames;
    }

    public ObLoadDupActionType getDupAction() {
        return this.dupAction;
    }

    public int getParallel() {
        return this.parallel;
    }

    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    public long getMaxErrorRowCount() {
        return this.maxErrorRowCount;
    }

    public String getLoadMethod() {
        return this.loadMethod;
    }

    public void checkTimeout() throws ObDirectLoadException {
        if (this.startQueryTimeMillis == 0L) {
            this.logger.warn("statement not start");
            throw new ObDirectLoadUnexpectedException("statement not start");
        }
        if (this.startQueryTimeMillis + this.queryTimeout < System.currentTimeMillis()) {
            this.logger.warn("statement timeout");
            throw new ObDirectLoadTimeoutException("statement timeout");
        }
    }

    public long getTimeoutRemain() {
        long remainTimeout = this.queryTimeout;
        if (this.startQueryTimeMillis > 0L) {
            remainTimeout -= System.currentTimeMillis() - this.startQueryTimeMillis;
        }
        return remainTimeout;
    }

    public ObDirectLoadConnection.ObTablePool getObTablePool() {
        return this.obTablePool;
    }

    @Deprecated
    public void setBeginRpcTimeout(long timeoutMillis) {
    }

    @Deprecated
    public void setWriteRpcTimeout(long timeoutMillis) {
    }

    public String toString() {
        return String.format("{tableName:%s, columnNames:%s, partitionNames:%s, dupAction:%s, parallel:%d, queryTimeout:%d, maxErrorRowCount:%d, loadMethod:%s, executor:%s}", new Object[]{this.tableName, Arrays.toString(this.columnNames), Arrays.toString(this.partitionNames), this.dupAction, this.parallel, this.queryTimeout, this.maxErrorRowCount, this.loadMethod, this.executor});
    }

    public ObDirectLoadStatementFuture beginAsync() {
        try {
            this.checkStatus();
            return this.executor.begin();
        }
        catch (ObDirectLoadException e) {
            this.logger.warn("statement begin failed", e);
            return new ObDirectLoadStatementFailedFuture(this, e);
        }
    }

    public void begin() throws ObDirectLoadException {
        ObDirectLoadStatementFuture future = this.beginAsync();
        future.await();
        if (!future.isSuccess()) {
            throw future.cause();
        }
    }

    public ObDirectLoadStatementFuture commitAsync() {
        try {
            this.checkStatus();
            return this.executor.commit();
        }
        catch (ObDirectLoadException e) {
            this.logger.warn("statement commit failed", e);
            return new ObDirectLoadStatementFailedFuture(this, e);
        }
    }

    public void commit() throws ObDirectLoadException {
        ObDirectLoadStatementFuture future = this.commitAsync();
        future.await();
        if (!future.isSuccess()) {
            throw future.cause();
        }
    }

    public void write(ObDirectLoadBucket bucket) throws ObDirectLoadException {
        if (bucket == null || bucket.isEmpty()) {
            this.logger.warn("Param 'bucket' must not be null or empty, value:" + bucket);
            throw new ObDirectLoadIllegalArgumentException("Param 'bucket' must not be null or empty, value:" + bucket);
        }
        this.checkStatus();
        this.executor.write(bucket);
    }

    public ObDirectLoadStatementExecutionId getExecutionId() throws ObDirectLoadException {
        this.checkStatus();
        return this.executor.getExecutionId();
    }

    public void resume(ObDirectLoadStatementExecutionId executionId) throws ObDirectLoadException {
        if (executionId == null || !executionId.isValid()) {
            this.logger.warn("Param 'executionId' must not be null or invalid, value:" + executionId);
            throw new ObDirectLoadIllegalArgumentException("Param 'executionId' must not be null or invalid, value:" + executionId);
        }
        this.checkStatus();
        this.executor.resume(executionId);
    }

    public static final class Builder {
        private final ObDirectLoadConnection connection;
        private String tableName = null;
        private String[] columnNames = null;
        private String[] partitionNames = null;
        private ObLoadDupActionType dupAction = ObLoadDupActionType.INVALID_MODE;
        private int parallel = 0;
        private long queryTimeout = 0L;
        private long maxErrorRowCount = 0L;
        private String loadMethod = "full";
        private static final long MAX_QUERY_TIMEOUT = 31536000000L;

        Builder(ObDirectLoadConnection connection) {
            this.connection = connection;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setColumnNames(String[] columnNames) {
            this.columnNames = columnNames;
            return this;
        }

        public Builder setPartitionNames(String[] partitionNames) {
            this.partitionNames = partitionNames;
            return this;
        }

        public Builder setDupAction(ObLoadDupActionType dupAction) {
            this.dupAction = dupAction;
            return this;
        }

        public Builder setParallel(int parallel) {
            this.parallel = parallel;
            return this;
        }

        public Builder setQueryTimeout(long queryTimeout) {
            this.queryTimeout = Math.min(queryTimeout, 31536000000L);
            return this;
        }

        public Builder setMaxErrorRowCount(long maxErrorRowCount) {
            this.maxErrorRowCount = maxErrorRowCount;
            return this;
        }

        public Builder setLoadMethod(String loadMethod) {
            this.loadMethod = loadMethod;
            return this;
        }

        public String toString() {
            return String.format("{tableName:%s, columnNames:%s, partitionNames:%s, dupAction:%s, parallel:%d, queryTimeout:%d, maxErrorRowCount:%d, loadMethod:%s}", new Object[]{this.tableName, Arrays.toString(this.columnNames), Arrays.toString(this.partitionNames), this.dupAction, this.parallel, this.queryTimeout, this.maxErrorRowCount, this.loadMethod});
        }

        public ObDirectLoadStatement build() throws ObDirectLoadException {
            return this.connection.buildStatement(this);
        }
    }
}

