/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.exception;

import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadIllegalArgumentException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadIllegalStateException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadInterruptedException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadNullPointerException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadRpcChecksumErrorException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadRpcException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadRpcResponseNullException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadRpcSendFailedException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadRpcTimeoutException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadServerException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadServerStatusException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadTimeoutException;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObTableLoadClientStatus;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTableTransportException;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import io.netty.handler.timeout.TimeoutException;

public class ObDirectLoadExceptionUtil {
    public static ObDirectLoadException convertException(Exception e) {
        if (e instanceof ObDirectLoadException) {
            return (ObDirectLoadException)e;
        }
        if (e instanceof NullPointerException) {
            return new ObDirectLoadNullPointerException(e);
        }
        if (e instanceof IllegalArgumentException) {
            return new ObDirectLoadIllegalArgumentException(e);
        }
        if (e instanceof IllegalStateException) {
            return new ObDirectLoadIllegalStateException(e);
        }
        if (e instanceof java.util.concurrent.TimeoutException) {
            return new ObDirectLoadTimeoutException(e);
        }
        if (e instanceof TimeoutException) {
            return new ObDirectLoadTimeoutException(e);
        }
        if (e instanceof InterruptedException) {
            return new ObDirectLoadInterruptedException(e);
        }
        if (e instanceof ObTableTransportException) {
            int errorCode = ((ObTableTransportException)e).getErrorCode();
            if (errorCode == -20002) {
                return new ObDirectLoadRpcTimeoutException(e);
            }
            if (errorCode == -20003) {
                return new ObDirectLoadRpcSendFailedException(e);
            }
            if (errorCode == -20001) {
                return new ObDirectLoadRpcResponseNullException(e);
            }
            if (errorCode == -20004) {
                return new ObDirectLoadRpcChecksumErrorException(e);
            }
            return new ObDirectLoadRpcException(e);
        }
        if (e instanceof ObTableException) {
            int errorCode = ((ObTableException)e).getErrorCode();
            return new ObDirectLoadServerException(errorCode, (Throwable)e);
        }
        return new ObDirectLoadException(e);
    }

    public static ObDirectLoadInterruptedException convertException(InterruptedException e) {
        return new ObDirectLoadInterruptedException(e);
    }

    public static ObDirectLoadServerStatusException convertException(ObTableLoadClientStatus status, int errorCode) {
        ResultCodes resultCodes = ResultCodes.valueOf(errorCode);
        if (resultCodes != null) {
            return new ObDirectLoadServerStatusException(status, resultCodes);
        }
        return new ObDirectLoadServerStatusException(status, errorCode);
    }
}

