/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.execution;

import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadConnection;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadRuntimeInfo;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadStatement;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadExceptionUtil;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadServerStatusException;
import com.alipay.oceanbase.rpc.direct_load.execution.ObDirectLoadStatementExecutor;
import com.alipay.oceanbase.rpc.direct_load.future.ObDirectLoadStatementAsyncPromiseTask;
import com.alipay.oceanbase.rpc.direct_load.protocol.ObDirectLoadProtocol;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObDirectLoadCommitRpc;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObDirectLoadGetStatusRpc;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObTableLoadClientStatus;
import com.alipay.oceanbase.rpc.direct_load.util.ObDirectLoadIntervalUtil;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.table.ObTable;
import java.util.concurrent.TimeUnit;

public class ObDirectLoadStatementCommitTask
extends ObDirectLoadStatementAsyncPromiseTask {
    private final ObDirectLoadConnection connection;
    private final ObDirectLoadProtocol protocol;
    private final ObDirectLoadStatementExecutor executor;
    private final ObDirectLoadStatementExecutor.CommitProxy proxy;
    private static final int STATE_NONE = 0;
    private static final int STATE_SEND_COMMIT = 1;
    private static final int STATE_WAIT_STATUS_COMMIT = 2;
    private static final int STATE_SUCC = 3;
    private static final int STATE_FAIL = 4;
    private int state = 0;
    private ObDirectLoadIntervalUtil intervalUtil = new ObDirectLoadIntervalUtil();
    private ObDirectLoadRuntimeInfo runtimeInfo = new ObDirectLoadRuntimeInfo();

    public ObDirectLoadStatementCommitTask(ObDirectLoadStatement statement, ObDirectLoadStatementExecutor executor) {
        super(statement);
        this.connection = statement.getConnection();
        this.protocol = this.connection.getProtocol();
        this.executor = executor;
        this.proxy = executor.getCommitProxy();
    }

    @Override
    public ObDirectLoadRuntimeInfo getRuntimeInfo() {
        return this.runtimeInfo;
    }

    @Override
    public void run() {
        this.runtimeInfo.incScheduledCount();
        this.runtimeInfo.setLastScheduledTime(System.currentTimeMillis());
        try {
            this.proxy.checkStatus();
            if (this.state == 0) {
                this.state = 1;
            }
            if (this.state == 1) {
                this.sendCommit();
            }
            if (this.state == 2) {
                this.waitStatusCommit();
            }
            if (this.state == 3) {
                this.proxy.setSuccess();
                this.setSuccess();
            }
        }
        catch (ObDirectLoadException e) {
            this.logger.warn("statement commit task run failed", e);
            this.state = 4;
            this.proxy.setFailure(e);
            this.setFailure(e);
        }
    }

    private void sendCommit() throws ObDirectLoadException {
        try {
            this.doSendCommit();
            this.state = 2;
        }
        catch (ObDirectLoadException e) {
            this.logger.warn("statement send commit rpc failed", e);
            throw e;
        }
    }

    private ObDirectLoadCommitRpc doSendCommit() throws ObDirectLoadException {
        ObTable table = this.statement.getObTablePool().getControlObTable();
        long timeoutMillis = this.statement.getTimeoutRemain();
        ObDirectLoadCommitRpc rpc = this.protocol.getCommitRpc(this.executor.getTraceId());
        rpc.setSvrAddr(this.executor.getSvrAddr());
        rpc.setTableId(this.executor.getTableId());
        rpc.setTaskId(this.executor.getTaskId());
        this.logger.info("statement send commit rpc, arg:" + rpc.getArg());
        this.connection.executeWithConnection(rpc, table, timeoutMillis);
        this.logger.info("statement commit rpc response successful, res:" + rpc.getRes());
        return rpc;
    }

    private void waitStatusCommit() throws ObDirectLoadException {
        try {
            ObDirectLoadGetStatusRpc rpc = null;
            try {
                rpc = this.doGetStatus();
            }
            catch (ObDirectLoadException e) {
                this.logger.warn("statement send get status rpc failed", e);
                throw e;
            }
            ObTableLoadClientStatus status = rpc.getStatus();
            int errorCode = rpc.getErrorCode();
            switch (status) {
                case COMMITTING: {
                    if (this.intervalUtil.reachTimeInterval(10000L)) {
                        this.logger.info("statement waiting server status reach commit, status:" + (Object)((Object)status));
                    }
                    this.schedule(500L, TimeUnit.MILLISECONDS);
                    break;
                }
                case COMMIT: {
                    this.logger.info("statement server status reach commit");
                    this.state = 3;
                    break;
                }
                case ERROR: {
                    this.logger.warn("statement server status is error, errorCode:" + errorCode);
                    throw ObDirectLoadExceptionUtil.convertException(status, errorCode);
                }
                case ABORT: {
                    this.logger.warn("statement server status is abort, errorCode:" + errorCode);
                    if (errorCode == ResultCodes.OB_SUCCESS.errorCode) {
                        errorCode = ResultCodes.OB_CANCELED.errorCode;
                    }
                    throw ObDirectLoadExceptionUtil.convertException(status, errorCode);
                }
                default: {
                    this.logger.warn("statement server status is unexpected, status:" + (Object)((Object)status));
                    throw ObDirectLoadExceptionUtil.convertException(status, errorCode);
                }
            }
        }
        catch (ObDirectLoadException e) {
            if (e instanceof ObDirectLoadServerStatusException) {
                throw e;
            }
            this.schedule(500L, TimeUnit.MILLISECONDS);
        }
    }

    private ObDirectLoadGetStatusRpc doGetStatus() throws ObDirectLoadException {
        ObTable table = this.statement.getObTablePool().getControlObTable();
        long timeoutMillis = this.statement.getTimeoutRemain();
        ObDirectLoadGetStatusRpc rpc = this.protocol.getGetStatusRpc(this.executor.getTraceId());
        rpc.setSvrAddr(this.executor.getSvrAddr());
        rpc.setTableId(this.executor.getTableId());
        rpc.setTaskId(this.executor.getTaskId());
        this.logger.debug("statement send get status rpc, arg:" + rpc.getArg());
        this.connection.executeWithConnection(rpc, table, timeoutMillis);
        this.logger.debug("statement get status rpc response successful, res:" + rpc.getRes());
        return rpc;
    }
}

