/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.execution;

import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadIllegalArgumentException;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObAddr;
import com.alipay.oceanbase.rpc.util.ObByteBuf;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class ObDirectLoadStatementExecutionId {
    private long tableId = 0L;
    private long taskId = 0L;
    private ObAddr svrAddr = new ObAddr();

    public ObDirectLoadStatementExecutionId() {
    }

    public ObDirectLoadStatementExecutionId(long tableId, long taskId, ObAddr svrAddr) throws ObDirectLoadException {
        if (tableId < 0L || taskId <= 0L || svrAddr == null) {
            throw new ObDirectLoadIllegalArgumentException(String.format("invalid args, tableId:%d, taskId:%d, svrAddr:%s", tableId, taskId, svrAddr));
        }
        this.tableId = tableId;
        this.taskId = taskId;
        this.svrAddr = svrAddr;
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public ObAddr getSvrAddr() {
        return this.svrAddr;
    }

    public boolean isValid() {
        return this.tableId >= 0L && this.taskId > 0L && this.svrAddr.isValid();
    }

    public String toString() {
        return String.format("{tableId:%d, taskId:%d, svrAddr:%s}", this.tableId, this.taskId, this.svrAddr);
    }

    public byte[] encode() {
        int needBytes = this.getEncodedSize();
        ObByteBuf buf = new ObByteBuf(needBytes);
        this.encode(buf);
        return buf.bytes;
    }

    public void encode(ObByteBuf buf) {
        Serialization.encodeVi64(buf, this.tableId);
        Serialization.encodeVi64(buf, this.taskId);
        this.svrAddr.encode(buf);
    }

    public ObDirectLoadStatementExecutionId decode(ByteBuf buf) {
        this.tableId = Serialization.decodeVi64(buf);
        this.taskId = Serialization.decodeVi64(buf);
        this.svrAddr.decode(buf);
        return this;
    }

    public ObDirectLoadStatementExecutionId decode(byte[] bytes) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
        return this.decode(buf);
    }

    public int getEncodedSize() {
        int len = 0;
        len += Serialization.getNeedBytes(this.tableId);
        len += Serialization.getNeedBytes(this.taskId);
        return len += this.svrAddr.getEncodedSize();
    }
}

