/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.execution;

import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadBucket;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadConnection;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadLogger;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadStatement;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadTraceId;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadIllegalStateException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadInterruptedException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadUnexpectedException;
import com.alipay.oceanbase.rpc.direct_load.execution.ObDirectLoadStatementAbortTask;
import com.alipay.oceanbase.rpc.direct_load.execution.ObDirectLoadStatementBeginTask;
import com.alipay.oceanbase.rpc.direct_load.execution.ObDirectLoadStatementCommitTask;
import com.alipay.oceanbase.rpc.direct_load.execution.ObDirectLoadStatementExecutionId;
import com.alipay.oceanbase.rpc.direct_load.execution.ObDirectLoadStatementHeartBeatTask;
import com.alipay.oceanbase.rpc.direct_load.execution.ObDirectLoadStatementWriteTask;
import com.alipay.oceanbase.rpc.direct_load.future.ObDirectLoadStatementFailedFuture;
import com.alipay.oceanbase.rpc.direct_load.future.ObDirectLoadStatementFuture;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObAddr;
import java.util.concurrent.atomic.AtomicInteger;

public class ObDirectLoadStatementExecutor {
    private static final int NONE = 0;
    private static final int BEGINNING = 1;
    private static final int LOADING = 2;
    private static final int LOADING_ONLY = 3;
    private static final int COMMITTING = 4;
    private static final int COMMIT = 5;
    private static final int FAIL = 6;
    private static final int ABORT = 7;
    private AtomicInteger stateFlag = new AtomicInteger(0);
    private final ObDirectLoadStatement statement;
    private final ObDirectLoadTraceId traceId;
    private final ObDirectLoadLogger logger;
    private ObDirectLoadStatementFuture beginFuture = null;
    private ObDirectLoadStatementFuture commitFuture = null;
    private ObDirectLoadStatementHeartBeatTask heartBeatTask = null;
    private ObDirectLoadStatementFuture abortFuture = null;
    private long tableId = 0L;
    private long taskId = 0L;
    private ObAddr svrAddr = null;
    private ObDirectLoadException cause = null;

    public ObDirectLoadStatementExecutor(ObDirectLoadStatement statement) {
        this.statement = statement;
        this.traceId = statement.getTraceId();
        this.logger = statement.getLogger();
    }

    public ObDirectLoadStatement getStatement() {
        return this.statement;
    }

    public ObDirectLoadTraceId getTraceId() {
        return this.traceId;
    }

    public ObDirectLoadLogger getLogger() {
        return this.logger;
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public ObAddr getSvrAddr() {
        return this.svrAddr;
    }

    public String toString() {
        return String.format("{svrAddr:%s, tableId:%d, taskId:%d}", this.svrAddr, this.tableId, this.taskId);
    }

    public synchronized ObDirectLoadStatementFuture begin() {
        this.logger.info("statement call begin");
        ObDirectLoadStatementBeginTask task = null;
        try {
            this.compareAndSetState(0, 1, "begin");
        }
        catch (ObDirectLoadException e) {
            this.logger.warn("statement begin failed", e);
            return new ObDirectLoadStatementFailedFuture(this.statement, e);
        }
        try {
            task = new ObDirectLoadStatementBeginTask(this.statement, this);
            task.submit();
            this.beginFuture = task;
        }
        catch (ObDirectLoadException e) {
            this.logger.warn("statement start begin failed", e);
            this.cause = e;
            this.tryCompareAndSetState(1, 6, "set begin failure");
        }
        return task;
    }

    public synchronized ObDirectLoadStatementFuture commit() {
        this.logger.info("statement call commit");
        ObDirectLoadStatementCommitTask task = null;
        try {
            this.compareAndSetState(2, 4, "commit");
        }
        catch (ObDirectLoadException e) {
            this.logger.warn("statement commit failed", e);
            return new ObDirectLoadStatementFailedFuture(this.statement, e);
        }
        try {
            task = new ObDirectLoadStatementCommitTask(this.statement, this);
            task.submit();
            this.commitFuture = task;
        }
        catch (ObDirectLoadException e) {
            this.logger.warn("statement start commit failed", e);
            this.cause = e;
            this.tryCompareAndSetState(4, 6, "set commit failure");
        }
        return task;
    }

    public ObDirectLoadStatementExecutionId getExecutionId() throws ObDirectLoadException {
        this.checkState(2, "getExecutionId");
        ObDirectLoadStatementExecutionId executionId = new ObDirectLoadStatementExecutionId(this.tableId, this.taskId, this.svrAddr);
        return executionId;
    }

    public synchronized void resume(ObDirectLoadStatementExecutionId executionId) throws ObDirectLoadException {
        this.logger.info("statement call resume");
        try {
            this.compareAndSetState(0, 3, "resume");
        }
        catch (ObDirectLoadException e) {
            this.logger.warn("statement resume failed", e);
            throw e;
        }
        this.tableId = executionId.getTableId();
        this.taskId = executionId.getTaskId();
        this.svrAddr = executionId.getSvrAddr();
    }

    public synchronized void close() {
        if (this.beginFuture != null && !this.beginFuture.isDone()) {
            this.logger.info("statement close wait begin");
            try {
                this.beginFuture.await();
            }
            catch (ObDirectLoadInterruptedException e) {
                this.logger.warn("statement wait begin failed");
            }
        }
        this.beginFuture = null;
        if (this.commitFuture != null && !this.commitFuture.isDone()) {
            this.logger.info("statement close wait commit");
            try {
                this.commitFuture.await();
            }
            catch (ObDirectLoadInterruptedException e) {
                this.logger.warn("statement wait commit failed");
            }
        }
        this.commitFuture = null;
        if (this.heartBeatTask != null && !this.heartBeatTask.isDone()) {
            this.logger.info("statement close wait heart beat");
            boolean canceled = this.heartBeatTask.cancel();
            if (!canceled) {
                try {
                    this.heartBeatTask.await();
                }
                catch (ObDirectLoadInterruptedException e) {
                    this.logger.warn("statement wait heart beat failed");
                }
            }
        }
        this.heartBeatTask = null;
        this.abortIfNeed();
        if (this.abortFuture != null) {
            try {
                if (!this.abortFuture.isDone()) {
                    this.logger.info("statement close wait abort");
                    this.abortFuture.await();
                }
                if (!this.abortFuture.isSuccess()) {
                    throw this.abortFuture.cause();
                }
                this.logger.info("statement abort successful");
            }
            catch (ObDirectLoadException e) {
                this.logger.warn("statement abort failed", e);
            }
        }
    }

    private void abortIfNeed() {
        this.logger.debug("statement abort if need");
        if (this.abortFuture != null) {
            this.logger.debug("statement in abort");
            return;
        }
        int state = this.stateFlag.get();
        boolean needAbort = false;
        boolean unexpectedState = false;
        String reason = "";
        if (state == 0) {
            reason = "not begin";
        } else if (state == 1) {
            unexpectedState = true;
            reason = "begin not finish";
        } else if (state == 2) {
            needAbort = true;
        } else if (state == 3) {
            needAbort = false;
        } else if (state == 4) {
            unexpectedState = true;
            reason = "commit not finish";
        } else if (state == 5) {
            reason = "already commit";
        } else if (state == 6) {
            if (this.svrAddr != null) {
                needAbort = true;
            } else {
                reason = "begin fail";
            }
        } else if (state == 7) {
            reason = "already abort";
        }
        if (!needAbort) {
            if (unexpectedState) {
                this.logger.warn("statement cannot abort because " + reason);
            } else {
                this.logger.debug("statement no need abort because " + reason);
                this.setState(7);
            }
        } else {
            this.abort();
        }
    }

    private ObDirectLoadStatementFuture abort() {
        this.logger.info("statement call abort");
        this.setState(7);
        ObDirectLoadStatementAbortTask task = null;
        try {
            task = new ObDirectLoadStatementAbortTask(this.statement, this);
            task.submit();
            this.abortFuture = task;
        }
        catch (ObDirectLoadException e) {
            this.logger.warn("statement start abort failed", e);
        }
        return task;
    }

    void startHeartBeat() throws ObDirectLoadException {
        this.logger.info("statement start heart beat");
        try {
            ObDirectLoadStatementHeartBeatTask task = new ObDirectLoadStatementHeartBeatTask(this.statement, this);
            task.submit();
            this.heartBeatTask = task;
        }
        catch (ObDirectLoadException e) {
            this.logger.warn("statement start heart beat failed", e);
            throw e;
        }
    }

    void stopHeartBeat() {
        this.logger.info("statement stop heart beat");
        try {
            ObDirectLoadStatementHeartBeatTask task = this.heartBeatTask;
            if (task == null) {
                this.logger.warn("statement heart beat not start");
                throw new ObDirectLoadUnexpectedException("statement heart beat not start");
            }
            boolean canceled = task.cancel();
            if (!canceled) {
                return;
            }
            this.heartBeatTask = null;
        }
        catch (ObDirectLoadException e) {
            this.logger.warn("statement stop heart beat failed", e);
        }
    }

    public void write(ObDirectLoadBucket bucket) throws ObDirectLoadException {
        this.checkState(2, 3, "write");
        ObDirectLoadStatementWriteTask task = new ObDirectLoadStatementWriteTask(this.statement, this, bucket);
        task.run();
        if (!task.isDone()) {
            this.logger.warn("statement write task unexpected not done");
            throw new ObDirectLoadUnexpectedException("statement write task unexpected not done");
        }
        if (!task.isSuccess()) {
            throw task.cause();
        }
    }

    private String getUnexpectedStateReason(int state) {
        String reason = "";
        reason = state == 0 ? "not begin" : (state == 1 ? "is beginning" : (state == 2 ? "is loading" : (state == 4 ? "is committing" : (state == 5 ? "is commit" : (state == 6 || state == 7 ? "is fail" : "unknow state")))));
        return reason;
    }

    void compareAndSetState(int expect, int update, String action) throws ObDirectLoadIllegalStateException {
        if (!this.stateFlag.compareAndSet(expect, update)) {
            int state = this.stateFlag.get();
            String reason = this.getUnexpectedStateReason(state);
            String message = "statement cannot " + action + " because " + reason + ", state:" + state + ", expect:" + expect + ", update:" + update;
            this.logger.warn(message);
            if (this.cause == null) {
                throw new ObDirectLoadIllegalStateException(message);
            }
            throw new ObDirectLoadIllegalStateException(message, this.cause);
        }
    }

    boolean tryCompareAndSetState(int expect, int update, String action) {
        boolean bResult = this.stateFlag.compareAndSet(expect, update);
        if (!bResult) {
            int state = this.stateFlag.get();
            String reason = this.getUnexpectedStateReason(state);
            String message = "statement cannot " + action + " because " + reason + ", state:" + state + ", expect:" + expect + ", update:" + update;
            this.logger.warn(message);
        }
        return bResult;
    }

    void setState(int update) {
        this.stateFlag.set(update);
    }

    void checkState(int expect, String action) throws ObDirectLoadException {
        int state = this.stateFlag.get();
        if (state != expect) {
            String reason = this.getUnexpectedStateReason(state);
            String message = "statement cannot " + action + " because " + reason + ", state:" + state + ", expect:" + expect;
            this.logger.warn(message);
            if (this.cause == null) {
                throw new ObDirectLoadIllegalStateException(message);
            }
            throw new ObDirectLoadIllegalStateException(message, this.cause);
        }
    }

    void checkState(int start, int end, String action) throws ObDirectLoadIllegalStateException {
        int state = this.stateFlag.get();
        if (state < start || state > end) {
            String reason = this.getUnexpectedStateReason(state);
            String message = "statement cannot " + action + " because " + reason + ", state:" + state + ", expect:[" + start + ", " + end + "]";
            this.logger.warn(message);
            if (this.cause == null) {
                throw new ObDirectLoadIllegalStateException(message);
            }
            throw new ObDirectLoadIllegalStateException(message, this.cause);
        }
    }

    BeginProxy getBeginProxy() {
        return new BeginProxy(this);
    }

    CommitProxy getCommitProxy() {
        return new CommitProxy(this);
    }

    WriteProxy getWriteProxy() {
        return new WriteProxy(this);
    }

    HeartBeatProxy getHeartBeatProxy() {
        return new HeartBeatProxy(this);
    }

    static final class HeartBeatProxy
    extends BaseProxy {
        HeartBeatProxy(ObDirectLoadStatementExecutor executor) {
            super(executor);
        }

        @Override
        void checkState() throws ObDirectLoadException {
            this.executor.checkState(1, 5, "heart beat");
        }

        void setSuccess() throws ObDirectLoadException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setFailure(ObDirectLoadException cause) {
            try {
                this.executor.compareAndSetState(2, 6, "set heart beat failure");
            }
            catch (ObDirectLoadException e) {
                return;
            }
            this.executor.cause = cause;
            this.logger.warn("statement heart beat failed", cause);
            ObDirectLoadStatementExecutor obDirectLoadStatementExecutor = this.executor;
            synchronized (obDirectLoadStatementExecutor) {
                this.executor.abortIfNeed();
            }
        }
    }

    static final class WriteProxy
    extends BaseProxy {
        WriteProxy(ObDirectLoadStatementExecutor executor) {
            super(executor);
        }

        @Override
        void checkState() throws ObDirectLoadException {
            this.executor.checkState(2, 3, "write");
        }

        void setSuccess() throws ObDirectLoadException {
        }

        void setFailure(ObDirectLoadException cause) {
        }
    }

    static final class CommitProxy
    extends BaseProxy {
        CommitProxy(ObDirectLoadStatementExecutor executor) {
            super(executor);
        }

        @Override
        void checkState() throws ObDirectLoadException {
            this.executor.checkState(4, "commit");
        }

        void setSuccess() throws ObDirectLoadException {
            this.executor.compareAndSetState(4, 5, "set commit success");
            this.executor.commitFuture = null;
            this.logger.info("statement commit successful");
            this.executor.stopHeartBeat();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setFailure(ObDirectLoadException cause) {
            try {
                this.executor.compareAndSetState(4, 6, "set commit failure");
            }
            catch (ObDirectLoadException e) {
                return;
            }
            this.executor.cause = cause;
            this.logger.warn("statement commit failed", cause);
            ObDirectLoadStatementExecutor obDirectLoadStatementExecutor = this.executor;
            synchronized (obDirectLoadStatementExecutor) {
                this.executor.abortIfNeed();
            }
        }
    }

    static final class BeginProxy
    extends BaseProxy {
        BeginProxy(ObDirectLoadStatementExecutor executor) {
            super(executor);
        }

        @Override
        void checkState() throws ObDirectLoadException {
            this.executor.checkState(1, "begin");
        }

        void setSuccess0(ObAddr addr, long tableId, long taskId) throws ObDirectLoadException {
            this.executor.checkState(1, "begin");
            this.executor.svrAddr = addr;
            this.executor.tableId = tableId;
            this.executor.taskId = taskId;
            this.executor.startHeartBeat();
        }

        void setSuccess() throws ObDirectLoadException {
            this.executor.compareAndSetState(1, 2, "set begin success");
            this.executor.beginFuture = null;
            this.logger.info("statement begin successful");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setFailure(ObDirectLoadException cause) {
            try {
                this.executor.compareAndSetState(1, 6, "set begin failure");
            }
            catch (ObDirectLoadException e) {
                return;
            }
            this.executor.cause = cause;
            this.logger.warn("statement begin failed", cause);
            ObDirectLoadStatementExecutor obDirectLoadStatementExecutor = this.executor;
            synchronized (obDirectLoadStatementExecutor) {
                this.executor.abortIfNeed();
            }
        }

        void clear() {
            this.executor.stopHeartBeat();
        }
    }

    private static abstract class BaseProxy {
        protected final ObDirectLoadConnection connection;
        protected final ObDirectLoadStatement statement;
        protected final ObDirectLoadStatementExecutor executor;
        protected final ObDirectLoadLogger logger;

        BaseProxy(ObDirectLoadStatementExecutor executor) {
            this.executor = executor;
            this.statement = executor.getStatement();
            this.connection = this.statement.getConnection();
            this.logger = this.statement.getLogger();
        }

        void checkState() throws ObDirectLoadException {
        }

        void checkStatus() throws ObDirectLoadException {
            this.connection.checkStatus();
            this.statement.checkStatus();
            this.checkState();
            this.statement.checkTimeout();
        }
    }
}

