/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.execution;

import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadBucket;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadConnection;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadStatement;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadExceptionUtil;
import com.alipay.oceanbase.rpc.direct_load.execution.ObDirectLoadStatementExecutor;
import com.alipay.oceanbase.rpc.direct_load.future.ObDirectLoadStatementPromiseTask;
import com.alipay.oceanbase.rpc.direct_load.protocol.ObDirectLoadProtocol;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObDirectLoadInsertRpc;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.oceanbase.rpc.util.ObByteBuf;
import java.util.List;

public class ObDirectLoadStatementWriteTask
extends ObDirectLoadStatementPromiseTask {
    private final ObDirectLoadConnection connection;
    private final ObDirectLoadProtocol protocol;
    private final ObDirectLoadStatementExecutor executor;
    private final ObDirectLoadStatementExecutor.WriteProxy proxy;
    private final ObDirectLoadBucket bucket;

    public ObDirectLoadStatementWriteTask(ObDirectLoadStatement statement, ObDirectLoadStatementExecutor executor, ObDirectLoadBucket bucket) {
        super(statement);
        this.connection = statement.getConnection();
        this.protocol = this.connection.getProtocol();
        this.executor = executor;
        this.proxy = executor.getWriteProxy();
        this.bucket = bucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ObTable table = null;
        try {
            List<ObByteBuf> payloadBuffers = this.bucket.getPayloadBufferList();
            table = this.statement.getObTablePool().takeWriteObTable(this.statement.getTimeoutRemain());
            for (int index = 0; index < payloadBuffers.size(); ++index) {
                ObByteBuf payloadBuffer = payloadBuffers.get(index);
                this.sendInsert(table, payloadBuffer);
            }
            this.proxy.setSuccess();
            this.setSuccess();
            if (table != null) {
                this.statement.getObTablePool().putWriteObTable(table);
                table = null;
            }
        }
        catch (ObDirectLoadException e) {
            try {
                this.logger.warn("statement write task run failed", e);
                this.proxy.setFailure(e);
                this.setFailure(e);
                if (table != null) {
                    this.statement.getObTablePool().putWriteObTable(table);
                    table = null;
                }
            }
            catch (Throwable throwable) {
                if (table != null) {
                    this.statement.getObTablePool().putWriteObTable(table);
                    table = null;
                }
                throw throwable;
            }
        }
    }

    private void sendInsert(ObTable table, ObByteBuf payloadBuffer) throws ObDirectLoadException {
        int retryCount = 0;
        int retryInterval = 1;
        while (true) {
            this.proxy.checkStatus();
            try {
                long timeoutMillis = this.statement.getTimeoutRemain();
                this.doSendInsert(table, payloadBuffer, timeoutMillis);
                break;
            }
            catch (ObDirectLoadException e) {
                this.logger.warn("statement send insert failed, retry after " + retryInterval + "s, retryCount:" + retryCount, e);
                ++retryCount;
                try {
                    Thread.sleep(retryInterval * 1000);
                    if (retryInterval == 1) {
                        retryInterval = 2;
                        continue;
                    }
                    retryInterval = Math.min(retryInterval * retryInterval, 60);
                }
                catch (Exception ex) {
                    throw ObDirectLoadExceptionUtil.convertException(ex);
                }
            }
        }
    }

    private ObDirectLoadInsertRpc doSendInsert(ObTable table, ObByteBuf payloadBuffer, long timeoutMillis) throws ObDirectLoadException {
        ObDirectLoadInsertRpc rpc = this.protocol.getInsertRpc(this.executor.getTraceId());
        rpc.setSvrAddr(this.executor.getSvrAddr());
        rpc.setTableId(this.executor.getTableId());
        rpc.setTaskId(this.executor.getTaskId());
        rpc.setPayloadBuffer(payloadBuffer);
        this.logger.debug("statement send insert rpc, arg:" + rpc.getArg());
        this.connection.executeWithConnection(rpc, table, timeoutMillis);
        this.logger.debug("statement insert rpc response successful, res:" + rpc.getRes());
        return rpc;
    }
}

