/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.future;

import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadLogger;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadRuntimeInfo;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadStatement;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadExceptionUtil;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadInterruptedException;
import com.alipay.oceanbase.rpc.direct_load.future.ObDirectLoadStatementPromise;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ObDirectLoadStatementDefaultPromise
implements ObDirectLoadStatementPromise {
    protected final ObDirectLoadStatement statement;
    protected final ObDirectLoadLogger logger;
    private CountDownLatch waiter = new CountDownLatch(1);
    private static int NONE = 0;
    private static int SET_RESULT = 1;
    private static int SUCC = 2;
    private static int FAIL = 3;
    private AtomicInteger resultFlag = new AtomicInteger(NONE);
    private ObDirectLoadException cause = null;

    public ObDirectLoadStatementDefaultPromise(ObDirectLoadStatement statement) {
        this.statement = statement;
        this.logger = statement.getLogger();
    }

    @Override
    public ObDirectLoadStatement getStatement() {
        return this.statement;
    }

    @Override
    public boolean isDone() {
        return this.resultFlag.get() > SET_RESULT;
    }

    @Override
    public boolean isSuccess() {
        return this.resultFlag.get() == SUCC;
    }

    @Override
    public ObDirectLoadException cause() {
        return this.cause;
    }

    @Override
    public void await() throws ObDirectLoadInterruptedException {
        try {
            this.waiter.await();
        }
        catch (InterruptedException e) {
            throw ObDirectLoadExceptionUtil.convertException(e);
        }
    }

    @Override
    public boolean await(long timeoutMillis) throws ObDirectLoadInterruptedException {
        try {
            return this.waiter.await(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw ObDirectLoadExceptionUtil.convertException(e);
        }
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws ObDirectLoadInterruptedException {
        try {
            return this.waiter.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw ObDirectLoadExceptionUtil.convertException(e);
        }
    }

    @Override
    public ObDirectLoadStatementPromise setSuccess() {
        if (this.resultFlag.compareAndSet(NONE, SET_RESULT)) {
            this.resultFlag.set(SUCC);
            this.waiter.countDown();
        }
        return this;
    }

    @Override
    public ObDirectLoadStatementPromise setFailure(ObDirectLoadException cause) {
        if (this.resultFlag.compareAndSet(NONE, SET_RESULT)) {
            this.cause = cause;
            this.resultFlag.set(FAIL);
            this.waiter.countDown();
        }
        return this;
    }

    @Override
    public ObDirectLoadRuntimeInfo getRuntimeInfo() {
        return new ObDirectLoadRuntimeInfo();
    }
}

