/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.protocol.v0;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadLogger;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadStatement;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadTraceId;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadNotSupportedException;
import com.alipay.oceanbase.rpc.direct_load.protocol.ObDirectLoadProtocol;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObDirectLoadAbortRpc;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObDirectLoadBeginRpc;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObDirectLoadCommitRpc;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObDirectLoadGetStatusRpc;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObDirectLoadHeartBeatRpc;
import com.alipay.oceanbase.rpc.direct_load.protocol.payload.ObDirectLoadInsertRpc;
import com.alipay.oceanbase.rpc.direct_load.protocol.v0.payload.ObDirectLoadAbortRpcV0;
import com.alipay.oceanbase.rpc.direct_load.protocol.v0.payload.ObDirectLoadBeginRpcV0;
import com.alipay.oceanbase.rpc.direct_load.protocol.v0.payload.ObDirectLoadCommitRpcV0;
import com.alipay.oceanbase.rpc.direct_load.protocol.v0.payload.ObDirectLoadGetStatusRpcV0;
import com.alipay.oceanbase.rpc.direct_load.protocol.v0.payload.ObDirectLoadHeartBeatRpcV0;
import com.alipay.oceanbase.rpc.direct_load.protocol.v0.payload.ObDirectLoadInsertRpcV0;

public class ObDirectLoadProtocolV0
implements ObDirectLoadProtocol {
    public static final long OB_VERSION_4_3_2_0 = ObGlobal.calcVersion(4, (short)3, (byte)2, (byte)0);
    private static final int PROTOCOL_VERSION = 0;
    private final ObDirectLoadLogger logger;
    private final long obVersion;

    public ObDirectLoadProtocolV0(ObDirectLoadTraceId traceId, long obVersion) {
        this.logger = ObDirectLoadLogger.getLogger(traceId);
        this.obVersion = obVersion;
    }

    @Override
    public void init() throws ObDirectLoadException {
    }

    @Override
    public int getProtocolVersion() {
        return 0;
    }

    @Override
    public void checkIsSupported(ObDirectLoadStatement statement) throws ObDirectLoadException {
        if (this.obVersion < OB_VERSION_4_3_2_0) {
            String loadMethod = statement.getLoadMethod();
            if (!loadMethod.isEmpty() && !loadMethod.equalsIgnoreCase("full")) {
                this.logger.warn("load method in ob version " + ObGlobal.getObVsnString(this.obVersion) + "is not supported, minimum version required is " + ObGlobal.getObVsnString(OB_VERSION_4_3_2_0));
                throw new ObDirectLoadNotSupportedException("load method in ob version " + ObGlobal.getObVsnString(this.obVersion) + " is not supported, minimum version required is " + ObGlobal.getObVsnString(OB_VERSION_4_3_2_0));
            }
        } else if (statement.getPartitionNames().length > 0) {
            this.logger.warn("partition names in ob version " + ObGlobal.getObVsnString(this.obVersion) + "is not supported");
            throw new ObDirectLoadNotSupportedException("partition names in ob version " + ObGlobal.getObVsnString(this.obVersion) + " is not supported");
        }
    }

    @Override
    public ObDirectLoadBeginRpc getBeginRpc(ObDirectLoadTraceId traceId) {
        return new ObDirectLoadBeginRpcV0(traceId);
    }

    @Override
    public ObDirectLoadCommitRpc getCommitRpc(ObDirectLoadTraceId traceId) {
        return new ObDirectLoadCommitRpcV0(traceId);
    }

    @Override
    public ObDirectLoadAbortRpc getAbortRpc(ObDirectLoadTraceId traceId) {
        return new ObDirectLoadAbortRpcV0(traceId);
    }

    @Override
    public ObDirectLoadGetStatusRpc getGetStatusRpc(ObDirectLoadTraceId traceId) {
        return new ObDirectLoadGetStatusRpcV0(traceId);
    }

    @Override
    public ObDirectLoadInsertRpc getInsertRpc(ObDirectLoadTraceId traceId) {
        return new ObDirectLoadInsertRpcV0(traceId);
    }

    @Override
    public ObDirectLoadHeartBeatRpc getHeartBeatRpc(ObDirectLoadTraceId traceId) {
        return new ObDirectLoadHeartBeatRpcV0(traceId);
    }
}

