/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.protocol.v0.payload;

import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadLogger;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadTraceId;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadExceptionUtil;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadUnexpectedException;
import com.alipay.oceanbase.rpc.direct_load.protocol.ObDirectLoadRpc;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ObSimplePayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadResult;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;

public abstract class ObDirectLoadDefaultRpcV0
implements ObDirectLoadRpc {
    protected final ObDirectLoadLogger logger;
    protected final ObTableDirectLoadRequest request;
    protected ObTableDirectLoadResult result;

    public ObDirectLoadDefaultRpcV0(ObDirectLoadTraceId traceId) {
        this.logger = ObDirectLoadLogger.getLogger(traceId);
        this.request = new ObTableDirectLoadRequest();
        this.request.setTraceId(traceId.getUniqueId(), traceId.getSequence());
    }

    @Override
    public ObPayload getRequest() {
        ObTableDirectLoadRequest.Header header = this.request.getHeader();
        header.setOperationType(this.getOpType());
        this.request.setArgContent(new ObBytesString(this.getArg().encode()));
        return this.request;
    }

    @Override
    public void setResult(ObPayload result) throws ObDirectLoadException {
        if (!(result instanceof ObTableDirectLoadResult)) {
            throw new ObDirectLoadUnexpectedException("unexpected result type, result:" + result);
        }
        this.result = (ObTableDirectLoadResult)result;
        ObTableDirectLoadResult.Header header = this.result.getHeader();
        ObBytesString resContent = this.result.getResContent();
        if (header.getOperationType() != this.getOpType()) {
            this.logger.warn("operation type in result header is error, type:" + (Object)((Object)header.getOperationType()));
            throw new ObDirectLoadUnexpectedException("operation type in result header is error, type:" + (Object)((Object)header.getOperationType()));
        }
        ObSimplePayload res = this.getRes();
        if (res == null) {
            if (resContent.length() != 0) {
                this.logger.warn("res content must be empty");
                throw new ObDirectLoadUnexpectedException("res content must be empty");
            }
        } else {
            if (resContent.length() == 0) {
                this.logger.warn("res content cannot be empty");
                throw new ObDirectLoadUnexpectedException("res content cannot be empty");
            }
            ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(this.result.getResContent().length());
            try {
                buf.writeBytes(resContent.bytes);
                res.decode(buf);
            }
            catch (Exception e) {
                throw ObDirectLoadExceptionUtil.convertException(e);
            }
            finally {
                buf.release();
            }
        }
    }

    @Override
    public void setRpcTimeout(long timeoutMillis) {
        this.request.setTimeout(timeoutMillis * 1000L);
    }
}

