/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.protocol.v0.payload.impl;

import com.alipay.oceanbase.rpc.protocol.payload.ObSimplePayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObLoadDupActionType;
import com.alipay.oceanbase.rpc.util.ObByteBuf;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;

public class ObTableDirectLoadBeginArg
implements ObSimplePayload {
    private String tableName;
    private long parallel = 0L;
    private long maxErrorRowCount = 0L;
    private ObLoadDupActionType dupAction = ObLoadDupActionType.INVALID_MODE;
    private long timeout = 0L;
    private long heartBeatTimeout = 0L;
    private boolean forceCreate = false;
    private boolean asyncBegin = false;
    private String loadMethod = new String();
    private String[] columnNames = new String[0];
    private String[] partitionNames = new String[0];

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public long getParallel() {
        return this.parallel;
    }

    public void setParallel(long parallel) {
        this.parallel = parallel;
    }

    public long getMaxErrorRowCount() {
        return this.maxErrorRowCount;
    }

    public void setMaxErrorRowCount(long maxErrorRowCount) {
        this.maxErrorRowCount = maxErrorRowCount;
    }

    public ObLoadDupActionType getDupAction() {
        return this.dupAction;
    }

    public void setDupAction(ObLoadDupActionType dupAction) {
        this.dupAction = dupAction;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getHeartBeatTimeout() {
        return this.heartBeatTimeout;
    }

    public void setHeartBeatTimeout(long heartBeatTimeout) {
        this.heartBeatTimeout = heartBeatTimeout;
    }

    public boolean getForceCreate() {
        return this.forceCreate;
    }

    public void setForceCreate(boolean forceCreate) {
        this.forceCreate = forceCreate;
    }

    public boolean getAsyncBegin() {
        return this.asyncBegin;
    }

    public void setAsyncBegin(boolean asyncBegin) {
        this.asyncBegin = asyncBegin;
    }

    public String getLoadMethod() {
        return this.loadMethod;
    }

    public void setLoadMethod(String loadMethod) {
        this.loadMethod = loadMethod;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public String[] getPartitionNames() {
        return this.partitionNames;
    }

    public void setPartitionNames(String[] partitionNames) {
        this.partitionNames = partitionNames;
    }

    public String toString() {
        return String.format("{tableName:%s, parallel:%d, maxErrorRowCount:%d, dupAction:%s, timeout:%d, heartBeatTimeout:%d, forceCreate:%s, asyncBegin:%s, loadMethod:%s, columnNames:%s, partitionNames:%s}", new Object[]{this.tableName, this.parallel, this.maxErrorRowCount, this.dupAction, this.timeout, this.heartBeatTimeout, this.forceCreate, this.asyncBegin, this.loadMethod, Arrays.toString(this.columnNames), Arrays.toString(this.partitionNames)});
    }

    @Override
    public byte[] encode() {
        int needBytes = this.getEncodedSize();
        ObByteBuf buf = new ObByteBuf(needBytes);
        this.encode(buf);
        return buf.bytes;
    }

    @Override
    public void encode(ObByteBuf buf) {
        Serialization.encodeVString(buf, this.tableName);
        Serialization.encodeVi64(buf, this.parallel);
        Serialization.encodeVi64(buf, this.maxErrorRowCount);
        Serialization.encodeI8(buf, this.dupAction.getByteValue());
        Serialization.encodeVi64(buf, this.timeout);
        Serialization.encodeVi64(buf, this.heartBeatTimeout);
        Serialization.encodeI8(buf, (byte)(this.forceCreate ? 1 : 0));
        Serialization.encodeI8(buf, (byte)(this.asyncBegin ? 1 : 0));
        Serialization.encodeVString(buf, this.loadMethod);
        Serialization.encodeVStringArray(buf, this.columnNames);
        Serialization.encodeVStringArray(buf, this.partitionNames);
    }

    @Override
    public ObTableDirectLoadBeginArg decode(ByteBuf buf) {
        this.tableName = Serialization.decodeVString(buf);
        this.parallel = Serialization.decodeVi64(buf);
        this.maxErrorRowCount = Serialization.decodeVi64(buf);
        this.dupAction = ObLoadDupActionType.valueOf(Serialization.decodeI8(buf));
        this.timeout = Serialization.decodeVi64(buf);
        this.heartBeatTimeout = Serialization.decodeVi64(buf);
        this.forceCreate = Serialization.decodeI8(buf) != 0;
        this.asyncBegin = Serialization.decodeI8(buf) != 0;
        this.loadMethod = Serialization.decodeVString(buf);
        this.columnNames = Serialization.decodeVStringArray(buf);
        this.partitionNames = Serialization.decodeVStringArray(buf);
        return this;
    }

    @Override
    public int getEncodedSize() {
        int len = 0;
        len += Serialization.getNeedBytes(this.tableName);
        len += Serialization.getNeedBytes(this.parallel);
        len += Serialization.getNeedBytes(this.maxErrorRowCount);
        ++len;
        len += Serialization.getNeedBytes(this.timeout);
        len += Serialization.getNeedBytes(this.heartBeatTimeout);
        ++len;
        ++len;
        len += Serialization.getNeedBytes(this.loadMethod);
        len += Serialization.getNeedBytes(this.columnNames);
        return len += Serialization.getNeedBytes(this.partitionNames);
    }
}

