/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.protocol.v0.payload.impl;

import com.alipay.oceanbase.rpc.protocol.payload.ObSimplePayload;
import com.alipay.oceanbase.rpc.util.ObByteBuf;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObTableDirectLoadInsertArg
implements ObSimplePayload {
    private static final ObBytesString emptyPayload = new ObBytesString();
    private static final ObByteBuf emptyPayloadBuffer = new ObByteBuf(0);
    private long tableId = 0L;
    private long taskId = 0L;
    private ObBytesString payload = emptyPayload;
    private ObByteBuf payloadBuffer = emptyPayloadBuffer;

    public long getTableId() {
        return this.tableId;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public ObBytesString getPayload() {
        return this.payload;
    }

    public void setPayload(ObBytesString payload) {
        if (payload == null) {
            throw new NullPointerException();
        }
        this.payload = payload;
    }

    public String toString() {
        return String.format("{tableId:%d, taskId:%d, payload:%d, payloadBuffer:%d}", this.tableId, this.taskId, this.payload.length(), this.payloadBuffer.readableBytes());
    }

    public ObByteBuf getPayloadBuffer() {
        return this.payloadBuffer;
    }

    public void setPayloadBuffer(ObByteBuf payloadBuffer) {
        this.payloadBuffer = payloadBuffer;
    }

    @Override
    public byte[] encode() {
        int needBytes = this.getEncodedSize();
        ObByteBuf buf = new ObByteBuf(needBytes);
        this.encode(buf);
        return buf.bytes;
    }

    @Override
    public void encode(ObByteBuf buf) {
        Serialization.encodeVi64(buf, this.tableId);
        Serialization.encodeVi64(buf, this.taskId);
        if (this.payloadBuffer != emptyPayloadBuffer) {
            buf.writeBytes(this.payloadBuffer.bytes, 0, this.payloadBuffer.readableBytes());
        } else {
            Serialization.encodeBytesString(buf, this.payload);
        }
    }

    @Override
    public ObTableDirectLoadInsertArg decode(ByteBuf buf) {
        this.tableId = Serialization.decodeVi64(buf);
        this.taskId = Serialization.decodeVi64(buf);
        this.payload = Serialization.decodeBytesString(buf);
        return this;
    }

    @Override
    public int getEncodedSize() {
        return Serialization.getNeedBytes(this.tableId) + Serialization.getNeedBytes(this.taskId) + (this.payloadBuffer != emptyPayloadBuffer ? this.payloadBuffer.readableBytes() : Serialization.getNeedBytes(this.payload));
    }
}

