/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.util;

import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadLogger;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadIllegalArgumentException;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class ObDirectLoadUtil {
    private ObDirectLoadUtil() {
        ObjectUtil.checkNotNull(null, null);
    }

    public static <T> T checkNotNull(T arg, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        if (arg == null) {
            logger.warn("Param '" + name + "' must not be null");
            throw new ObDirectLoadIllegalArgumentException("Param '" + name + "' must not be null");
        }
        return arg;
    }

    public static int checkInRange(int i, int start, int end, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        if (i < start || i > end) {
            logger.warn("Param '" + name + "' is illegal value (expected: " + start + "-" + end + "), value:" + i);
            throw new ObDirectLoadIllegalArgumentException("Param '" + name + "' is illegal value (expected: " + start + "-" + end + "), value:" + i);
        }
        return i;
    }

    public static int checkPositive(int i, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        if (i <= 0) {
            logger.warn("Param '" + name + "' is illegal value (expected: > 0), value:" + i);
            throw new ObDirectLoadIllegalArgumentException("Param '" + name + "' is illegal value (expected: > 0), value:" + i);
        }
        return i;
    }

    public static long checkPositive(long l, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        if (l <= 0L) {
            logger.warn("Param '" + name + "' is illegal value (expected: > 0), value:" + l);
            throw new ObDirectLoadIllegalArgumentException("Param '" + name + "' is illegal value (expected: > 0), value:" + l);
        }
        return l;
    }

    public static int checkPositiveOrZero(int i, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        if (i < 0) {
            logger.warn("Param '" + name + "' is illegal value (expected: >= 0), value:" + i);
            throw new ObDirectLoadIllegalArgumentException("Param '" + name + "' is illegal value (expected: >= 0), value:" + i);
        }
        return i;
    }

    public static long checkPositiveOrZero(long l, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        if (l < 0L) {
            logger.warn("Param '" + name + "' is illegal value (expected: >= 0), value:" + l);
            throw new ObDirectLoadIllegalArgumentException("Param '" + name + "' is illegal value (expected: >= 0), value:" + l);
        }
        return l;
    }

    public static <T> T checkNonValid(T value, T invalidValue, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        if (value == null || value.equals(invalidValue)) {
            logger.warn("Param '" + name + "' must not be null or invalid value, value:" + value);
            throw new ObDirectLoadIllegalArgumentException("Param '" + name + "' must not be null or invalid value, value:" + value);
        }
        return value;
    }

    public static <T> T[] checkNonEmpty(T[] array, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        if (array == null || array.length == 0) {
            logger.warn("Param '" + name + "' must not be null or empty, value:" + Arrays.toString(array));
            throw new ObDirectLoadIllegalArgumentException("Param '" + name + "' must not be null or empty, value:" + Arrays.toString(array));
        }
        return array;
    }

    public static byte[] checkNonEmpty(byte[] array, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        if (array == null || array.length == 0) {
            logger.warn("Param '" + name + "' must not be null or empty, value:" + Arrays.toString(array));
            throw new ObDirectLoadIllegalArgumentException("Param '" + name + "' must not be null or empty, value:" + Arrays.toString(array));
        }
        return array;
    }

    public static char[] checkNonEmpty(char[] array, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        if (array == null || array.length == 0) {
            logger.warn("Param '" + name + "' must not be null or empty, value:" + Arrays.toString(array));
            throw new ObDirectLoadIllegalArgumentException("Param '" + name + "' must not be null or empty, value:" + Arrays.toString(array));
        }
        return array;
    }

    public static <T extends Collection<?>> T checkNonEmpty(T collection, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        if (collection == null || collection.isEmpty()) {
            logger.warn("Param '" + name + "' must not be null or empty, value:" + collection);
            throw new ObDirectLoadIllegalArgumentException("Param '" + name + "' must not be null or empty, value:" + collection);
        }
        return collection;
    }

    public static String checkNonEmpty(String value, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        if (value == null || value.isEmpty()) {
            logger.warn("Param '" + name + "' must not be null or empty, value:" + value);
            throw new ObDirectLoadIllegalArgumentException("Param '" + name + "' must not be null or empty, value:" + value);
        }
        return value;
    }

    public static <K, V, T extends Map<K, V>> T checkNonEmpty(T value, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        if (value == null || value.isEmpty()) {
            logger.warn("Param '" + name + "' must not be null or empty, value:" + value);
            throw new ObDirectLoadIllegalArgumentException("Param '" + name + "' must not be null or empty, value:" + value);
        }
        return value;
    }

    public static String checkNonEmptyArrayParam(String value, int index, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        if (value == null || value.isEmpty()) {
            logger.warn("Array index " + index + " of parameter '" + name + "' must not be null or empty, value:" + value);
            throw new ObDirectLoadIllegalArgumentException("Array index " + index + " of parameter '" + name + "' must not be null or empty, value:" + value);
        }
        return value;
    }

    public static String[] deepCheckNonEmpty(String[] array, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        ObDirectLoadUtil.checkNonEmpty(array, name, logger);
        for (int index = 0; index < array.length; ++index) {
            ObDirectLoadUtil.checkNonEmptyArrayParam(array[index], index, name, logger);
        }
        return array;
    }

    public static String[] checkNonEmptyAndUnique(String[] array, String name, ObDirectLoadLogger logger) throws ObDirectLoadException {
        ObDirectLoadUtil.deepCheckNonEmpty(array, name, logger);
        for (int i = 0; i < array.length - 1; ++i) {
            for (int j = i + 1; j < array.length; ++j) {
                if (!array[i].equals(array[j])) continue;
                logger.warn("Param '" + name + "' must not contain repeated elements, array:" + Arrays.toString(array));
                throw new ObDirectLoadIllegalArgumentException("Param '" + name + "' must not contain repeated elements, array:" + Arrays.toString(array));
            }
        }
        return array;
    }
}

