/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTablePartitionConsistentException;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartFuncType;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObCollationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObColumn;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.util.ObHashUtils;
import com.alipay.oceanbase.rpc.util.RandomUtil;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;

public class ObKeyPartDesc
extends ObPartDesc {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObKeyPartDesc.class);
    private List<Long> completeWorks;
    private int partSpace = 0;
    private int partNum = 0;

    public ObKeyPartDesc() {
        this.setPartFuncType(ObPartFuncType.KEY);
    }

    public int getPartSpace() {
        return this.partSpace;
    }

    public void setPartSpace(int partSpace) {
        this.partSpace = partSpace;
    }

    @Override
    public int getPartNum() {
        return this.partNum;
    }

    @Override
    public void setPartNum(int partNum) {
        this.partNum = partNum;
        ArrayList<Long> partIds = new ArrayList<Long>();
        for (long i = 0L; i < (long)partNum; ++i) {
            partIds.add(i);
        }
        this.completeWorks = Collections.unmodifiableList(partIds);
    }

    @Override
    public List<Long> getPartIds(Object startRowObj, boolean startInclusive, Object endRowObj, boolean endInclusive) {
        try {
            if (!(startRowObj instanceof Row) || !(endRowObj instanceof Row)) {
                throw new ObTableException("invalid format of rowObj: " + startRowObj + ", " + endRowObj);
            }
            Row startRow = (Row)startRowObj;
            Row endRow = (Row)endRowObj;
            if (startRow.size() != endRow.size()) {
                throw new IllegalArgumentException("length of start key and end key is not equal");
            }
            if (startRow.size() == 1L && startRow.getValues()[0] instanceof ObObj && ((ObObj)startRow.getValues()[0]).isMinObj() && endRow.size() == 1L && endRow.getValues()[0] instanceof ObObj && ((ObObj)endRow.getValues()[0]).isMaxObj()) {
                return this.completeWorks;
            }
            for (ObColumn curObcolumn : this.partColumns) {
                for (int refIdx = 0; refIdx < curObcolumn.getRefColumnNames().size(); ++refIdx) {
                    String curObRefColumnName = curObcolumn.getRefColumnNames().get(refIdx);
                    if (startRow.size() <= (long)refIdx) {
                        throw new IllegalArgumentException("rowkey length is " + startRow.size() + ", which is shortest than " + refIdx);
                    }
                    Object startValue = null;
                    for (Map.Entry<String, Object> entry : startRow.getMap().entrySet()) {
                        if (!entry.getKey().equalsIgnoreCase(curObRefColumnName)) continue;
                        startValue = entry.getValue();
                        break;
                    }
                    if (startValue == null) {
                        throw new IllegalArgumentException("Please include all partition key in start range. Currently missing key: { " + curObRefColumnName + " }");
                    }
                    if (startValue instanceof ObObj && (((ObObj)startValue).isMinObj() || ((ObObj)startValue).isMaxObj())) {
                        return this.completeWorks;
                    }
                    Object endValue = null;
                    for (Map.Entry<String, Object> entry : endRow.getMap().entrySet()) {
                        if (!entry.getKey().equalsIgnoreCase(curObRefColumnName)) continue;
                        endValue = entry.getValue();
                        break;
                    }
                    if (endValue == null) {
                        throw new IllegalArgumentException("Please include all partition key in end range. Currently missing key: { " + curObRefColumnName + " }");
                    }
                    if (!(endValue instanceof ObObj) || !((ObObj)endValue).isMinObj() && !((ObObj)endValue).isMaxObj()) continue;
                    return this.completeWorks;
                }
            }
            List<Object> startValues = this.evalRowKeyValues(startRow);
            List<Object> endValues = this.evalRowKeyValues(endRow);
            if (startValues == null || endValues == null) {
                throw new NumberFormatException("can not parseToComparable start value [" + startValues + "] or end value [" + endValues + "] to long");
            }
            if (startValues.equals(endValues)) {
                ArrayList<Long> partIds = new ArrayList<Long>();
                partIds.add(this.calcPartId(startValues));
                return partIds;
            }
            return this.completeWorks;
        }
        catch (IllegalArgumentException e) {
            logger.error(TableClientLoggerFactory.LCD.convert("01-00002"), (Throwable)e);
            throw new IllegalArgumentException("ObKeyPartDesc get part id come across illegal params", e);
        }
    }

    @Override
    public Long getRandomPartId() {
        return this.partNum > 0 ? Long.valueOf(RandomUtil.getRandomNum(0, this.partNum)) : null;
    }

    @Override
    public Long getPartId(Object ... row) throws IllegalArgumentException {
        ArrayList<Object> rows = new ArrayList<Object>();
        rows.addAll(Arrays.asList(row));
        return this.getPartId(rows, false);
    }

    @Override
    public Long getPartId(List<Object> rows, boolean consistency) {
        if (rows == null || rows.size() == 0) {
            throw new IllegalArgumentException("invalid row keys :" + rows);
        }
        try {
            int partRefColumnSize = this.partColumns.size();
            List<Object> evalValues = null;
            for (Object rowObj : rows) {
                if (!(rowObj instanceof Row)) {
                    throw new ObTableException("invalid format of rowObj: " + rowObj);
                }
                Row row = (Row)rowObj;
                List<Object> currentRowKeyEvalValues = this.evalRowKeyValues(row);
                if (evalValues == null) {
                    evalValues = currentRowKeyEvalValues;
                }
                if (!consistency) break;
                if (evalValues == currentRowKeyEvalValues) continue;
                for (int i = 0; i < evalValues.size(); ++i) {
                    if (this.equalsWithCollationType(((ObColumn)this.partColumns.get(i)).getObCollationType(), evalValues.get(i), currentRowKeyEvalValues.get(i))) continue;
                    throw new ObTablePartitionConsistentException("across partition operation may cause consistent problem " + rows);
                }
            }
            return this.calcPartId(evalValues);
        }
        catch (IllegalArgumentException e) {
            logger.error(TableClientLoggerFactory.LCD.convert("01-00023"), (Throwable)e);
            throw new IllegalArgumentException("ObKeyPartDesc get part id come across illegal params", e);
        }
    }

    private Long calcPartId(List<Object> evalValues) {
        if (evalValues == null || evalValues.size() != this.partColumns.size()) {
            throw new IllegalArgumentException("invalid eval values :" + evalValues);
        }
        long hashValue = 0L;
        for (int i = 0; i < this.partColumns.size(); ++i) {
            hashValue = ObHashUtils.toHashcode(evalValues.get(i), (ObColumn)this.partColumns.get(i), hashValue, this.getPartFuncType());
        }
        hashValue = hashValue > 0L ? hashValue : -hashValue;
        return (long)this.partSpace << 28 | hashValue % (long)this.partNum;
    }

    private boolean equalsWithCollationType(ObCollationType collationType, Object s, Object t) throws IllegalArgumentException {
        if (collationType == ObCollationType.CS_TYPE_UTF8MB4_GENERAL_CI) {
            if (!(s instanceof String) || !(t instanceof String)) {
                throw new IllegalArgumentException("CS_TYPE_UTF8MB4_GENERAL_CI only allow string equal");
            }
            return ((String)s).equalsIgnoreCase((String)t);
        }
        return s.equals(t);
    }

    @Override
    public void setRowKeyElement(Map<String, Integer> rowKeyElement) {
        if (rowKeyElement == null || rowKeyElement.size() == 0) {
            throw new IllegalArgumentException("ObKeyPartDesc rowKeyElement is empty");
        }
        super.setRowKeyElement(rowKeyElement);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("partSpace", this.partSpace).append("partNum", this.partNum).append("partFuncType", (Object)this.getPartFuncType()).append("partExpr", (Object)this.getPartExpr()).toString();
    }
}

