/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.mutation;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.mutation.ColumnValue;
import com.alipay.oceanbase.rpc.mutation.Mutation;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.mutation.result.MutationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.table.api.Table;
import java.util.ArrayList;
import java.util.Map;

public class Increment
extends Mutation<Increment> {
    boolean withResult;

    public Increment() {
        this.columns = new ArrayList();
        this.values = new ArrayList();
        this.withResult = false;
    }

    public Increment(Table client, String tableName) {
        super(client, tableName);
        this.columns = new ArrayList();
        this.values = new ArrayList();
        this.withResult = false;
    }

    @Override
    public ObTableOperationType getOperationType() {
        return ObTableOperationType.INCREMENT;
    }

    public String[] getColumns() {
        return this.columns.toArray(new String[0]);
    }

    public Object[] getValues() {
        return this.values.toArray();
    }

    public Increment addMutateRow(Row rows) {
        if (null == rows) {
            throw new IllegalArgumentException("Invalid null rowKey set into Update");
        }
        if (0 == rows.getMap().size()) {
            throw new IllegalArgumentException("input row key should not be empty");
        }
        for (Map.Entry<String, Object> entry : rows.getMap().entrySet()) {
            this.columns.add(entry.getKey());
            this.values.add(entry.getValue());
        }
        return this;
    }

    public Increment addMutateColVal(ColumnValue ... columnValues) {
        if (null == columnValues) {
            throw new IllegalArgumentException("Invalid null columnValues set into Update");
        }
        for (ColumnValue columnValue : columnValues) {
            if (this.columns.contains(columnValue.getColumnName())) {
                throw new ObTableException("Duplicate column in Row Key");
            }
            this.columns.add(columnValue.getColumnName());
            this.values.add(columnValue.getValue());
        }
        return this;
    }

    public Increment removeRowkeyFromMutateColval() {
        Increment.removeRowkeyFromMutateColval(this.columns, this.values, this.rowKeyNames);
        return this;
    }

    public MutationResult execute() throws Exception {
        if (null == this.getTableName() || this.getTableName().isEmpty()) {
            throw new ObTableException("table name is null");
        }
        if (null == this.getClient()) {
            throw new ObTableException("client is null");
        }
        Increment.removeRowkeyFromMutateColval(this.columns, this.values, this.rowKeyNames);
        if (null == this.getQuery()) {
            return new MutationResult(((ObTableClient)this.getClient()).incrementWithResult(this.getTableName(), this.getRowKey(), this.getKeyRanges(), this.columns.toArray(new String[0]), this.values.toArray(), this.withResult));
        }
        ObTableOperation operation = ObTableOperation.getInstance(ObTableOperationType.INCREMENT, new Object[0], this.columns.toArray(new String[0]), this.values.toArray());
        return new MutationResult(((ObTableClient)this.getClient()).mutationWithFilter(this.getQuery(), this.getRowKey(), this.getKeyRanges(), operation, this.withResult));
    }
}

