/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.mutation.result;

import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.mutation.result.MutationResult;
import com.alipay.oceanbase.rpc.mutation.result.OperationResult;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import java.util.ArrayList;
import java.util.List;

public class BatchOperationResult {
    private List<Object> results;
    boolean hasError = false;

    public BatchOperationResult(List<Object> results) {
        this.results = results;
    }

    public List<Object> getResults() {
        return this.results;
    }

    public List<Integer> getErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        for (Object item : this.results) {
            int errorCode = ResultCodes.OB_SUCCESS.errorCode;
            if (item instanceof ObTableException) {
                errorCode = ((ObTableException)item).getErrorCode();
                this.hasError = true;
            }
            errorCodeList.add(errorCode);
        }
        return errorCodeList;
    }

    public boolean hasError() {
        if (!this.hasError) {
            for (Object item : this.results) {
                if (!(item instanceof ObTableException)) continue;
                this.hasError = true;
                break;
            }
        }
        return this.hasError;
    }

    public ObTableException getFirstException() {
        ObTableException exception = null;
        for (Object item : this.results) {
            if (!(item instanceof ObTableException)) continue;
            exception = (ObTableException)item;
            this.hasError = true;
            break;
        }
        return exception;
    }

    public OperationResult get(int pos) {
        if (pos >= this.results.size()) {
            throw new IllegalArgumentException("Invalid pos: " + pos + ", while size of results is: " + this.results.size());
        }
        return (MutationResult)this.results.get(pos);
    }

    public int size() {
        return this.results.size();
    }

    public long getWrongCount() {
        long wrongCount = 0L;
        for (Object item : this.results) {
            if (!(item instanceof ObTableException)) continue;
            ++wrongCount;
            this.hasError = true;
        }
        return wrongCount;
    }

    public long getCorrectCount() {
        long correctCount = 0L;
        for (Object item : this.results) {
            if (item instanceof ObTableException) continue;
            ++correctCount;
        }
        return correctCount;
    }

    public int[] getWrongIdx() {
        ArrayList<Integer> wrongIdx = new ArrayList<Integer>();
        Integer i = 0;
        for (Object item : this.results) {
            if (item instanceof ObTableException) {
                wrongIdx.add(i);
                this.hasError = true;
            }
            i = i + 1;
        }
        return wrongIdx.stream().mapToInt(Integer::intValue).toArray();
    }

    public int[] getCorrectIdx() {
        ArrayList<Integer> correctIdx = new ArrayList<Integer>();
        Integer i = 0;
        for (Object item : this.results) {
            if (!(item instanceof ObTableException)) {
                correctIdx.add(i);
            }
            i = i + 1;
        }
        return correctIdx.stream().mapToInt(Integer::intValue).toArray();
    }
}

