/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl;

import com.alipay.oceanbase.rpc.protocol.payload.ObSimplePayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObjMeta;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObjType;
import com.alipay.oceanbase.rpc.util.ObByteBuf;
import com.alipay.oceanbase.rpc.util.ObVString;
import io.netty.buffer.ByteBuf;

public class ObObj
implements ObSimplePayload {
    private static ObObj MAX_OBJECT;
    private static ObObj MIN_OBJECT;
    private static long MAX_OBJECT_VALUE;
    private static long MIN_OBJECT_VALUE;
    private ObObjMeta meta;
    private int valueLength;
    private Object value;

    public ObObj() {
        this.meta = new ObObjMeta();
        this.value = null;
    }

    public ObObj(ObObjMeta meta, Object value) {
        this.meta = meta;
        this.setValue(value);
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[this.getEncodedSize()];
        int idx = 0;
        System.arraycopy(this.meta.encode(), 0, bytes, idx, 4);
        byte[] valueBytes = this.meta.getType().encode(this.value);
        System.arraycopy(valueBytes, 0, bytes, idx += 4, valueBytes.length);
        idx += valueBytes.length;
        return bytes;
    }

    @Override
    public void encode(ObByteBuf buf) {
        this.meta.encode(buf);
        buf.writeBytes(this.meta.getType().encode(this.value));
    }

    @Override
    public ObObj decode(ByteBuf buf) {
        this.meta.decode(buf);
        this.value = this.meta.getType().decode(buf, this.meta.getCsType());
        return this;
    }

    @Override
    public int getEncodedSize() {
        return this.meta.getEncodedSize() + this.meta.getType().getEncodedSize(this.value);
    }

    public ObObjMeta getMeta() {
        return this.meta;
    }

    public void setMeta(ObObjMeta meta) {
        this.meta = meta;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public void setValueLength(int valueLength) {
        this.valueLength = valueLength;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value instanceof String ? new ObVString((String)value) : value;
    }

    public static ObObj getInstance(Object value) {
        ObObjMeta meta = ObObjType.defaultObjMeta(value);
        if (value instanceof ObObj) {
            return new ObObj(meta, ((ObObj)value).getValue());
        }
        return new ObObj(meta, value);
    }

    public static ObObj getMax() {
        return MAX_OBJECT;
    }

    public static ObObj getMin() {
        return MIN_OBJECT;
    }

    public String toString() {
        return "ObObj{meta=" + this.meta + ", valueLength=" + this.valueLength + ", value=" + this.value + '}';
    }

    public boolean isMinObj() {
        return this.getMeta().getType() == ObObjType.ObExtendType && (Long)this.getValue() == MIN_OBJECT_VALUE;
    }

    public boolean isMaxObj() {
        return this.getMeta().getType() == ObObjType.ObExtendType && (Long)this.getValue() == MAX_OBJECT_VALUE;
    }

    public void setValueFromTableObj(Object value) {
        this.value = value;
    }

    static {
        MAX_OBJECT_VALUE = -2L;
        MIN_OBJECT_VALUE = -3L;
        MAX_OBJECT = new ObObj(ObObjType.ObExtendType.getDefaultObjMeta(), MAX_OBJECT_VALUE);
        MIN_OBJECT = new ObObj(ObObjType.ObExtendType.getDefaultObjMeta(), MIN_OBJECT_VALUE);
    }
}

