/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObTableObjType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObBorderFlag;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObTableSerialUtil {
    public static int getEncodedSize(ObObj obj) {
        return ObTableObjType.getTableObjType(obj).getEncodedSize(obj);
    }

    public static byte[] encode(ObObj obj) {
        return ObTableObjType.getTableObjType(obj).encode(obj);
    }

    public static void decode(ByteBuf buf, ObObj obj) {
        ObTableObjType tableObjType = ObTableSerialUtil.decodeTableObjType(buf);
        tableObjType.decode(buf, obj);
    }

    public static ObTableObjType decodeTableObjType(ByteBuf buf) {
        if (buf == null) {
            throw new IllegalArgumentException("cannot get ObTableObjType, buf is null");
        }
        byte type = Serialization.decodeI8(buf);
        ObTableObjType objType = ObTableObjType.valueOf(type);
        if (objType == null) {
            throw new IllegalArgumentException("cannot get table object type from value");
        }
        return objType;
    }

    public static int getEncodedSize(ObNewRange range) {
        int encodedSize = 0;
        encodedSize += Serialization.getNeedBytes(range.getTableId());
        ++encodedSize;
        ObRowKey startKey = range.getStartKey();
        long rowkeySize = startKey.getObjCount();
        encodedSize += Serialization.getNeedBytes(rowkeySize);
        int i = 0;
        while ((long)i < rowkeySize) {
            ObObj obObj = startKey.getObj(i);
            encodedSize += ObTableSerialUtil.getEncodedSize(obObj);
            ++i;
        }
        ObRowKey endKey = range.getEndKey();
        rowkeySize = endKey.getObjCount();
        encodedSize += Serialization.getNeedBytes(rowkeySize);
        int i2 = 0;
        while ((long)i2 < rowkeySize) {
            ObObj obObj = endKey.getObj(i2);
            encodedSize += ObTableSerialUtil.getEncodedSize(obObj);
            ++i2;
        }
        if (ObGlobal.obVsnMajor() >= 4) {
            encodedSize += Serialization.getNeedBytes(range.getFlag());
        }
        return encodedSize;
    }

    public static byte[] encode(ObNewRange range) {
        byte[] bytes = new byte[ObTableSerialUtil.getEncodedSize(range)];
        int idx = 0;
        long tableId = range.getTableId();
        int len = Serialization.getNeedBytes(tableId);
        System.arraycopy(Serialization.encodeVi64(tableId), 0, bytes, idx, len);
        System.arraycopy(Serialization.encodeI8(range.getBorderFlag().getValue()), 0, bytes, idx += len, 1);
        ObRowKey startKey = range.getStartKey();
        long rowkeySize = startKey.getObjCount();
        len = Serialization.getNeedBytes(rowkeySize);
        System.arraycopy(Serialization.encodeVi64(rowkeySize), 0, bytes, ++idx, len);
        idx += len;
        int i = 0;
        while ((long)i < rowkeySize) {
            ObObj obObj = startKey.getObj(i);
            byte[] objBytes = ObTableSerialUtil.encode(obObj);
            System.arraycopy(objBytes, 0, bytes, idx, objBytes.length);
            idx += objBytes.length;
            ++i;
        }
        ObRowKey endKey = range.getEndKey();
        rowkeySize = endKey.getObjCount();
        len = Serialization.getNeedBytes(rowkeySize);
        System.arraycopy(Serialization.encodeVi64(rowkeySize), 0, bytes, idx, len);
        idx += len;
        int i2 = 0;
        while ((long)i2 < rowkeySize) {
            ObObj obObj = endKey.getObj(i2);
            byte[] objBytes = ObTableSerialUtil.encode(obObj);
            System.arraycopy(objBytes, 0, bytes, idx, objBytes.length);
            idx += objBytes.length;
            ++i2;
        }
        if (ObGlobal.obVsnMajor() >= 4) {
            long flag = range.getFlag();
            len = Serialization.getNeedBytes(flag);
            System.arraycopy(Serialization.encodeVi64(flag), 0, bytes, idx, len);
            idx += len;
        }
        return bytes;
    }

    public static void decode(ByteBuf buf, ObNewRange range) {
        range.setTableId(Serialization.decodeVi64(buf));
        range.setBorderFlag(ObBorderFlag.valueOf(Serialization.decodeI8(buf.readByte())));
        long rowkeySize = Serialization.decodeVi64(buf);
        ObRowKey startKey = new ObRowKey();
        int i = 0;
        while ((long)i < rowkeySize) {
            ObObj obObj = new ObObj();
            ObTableSerialUtil.decode(buf, obObj);
            startKey.addObj(obObj);
            ++i;
        }
        range.setStartKey(startKey);
        rowkeySize = Serialization.decodeVi64(buf);
        ObRowKey endKey = new ObRowKey();
        int i2 = 0;
        while ((long)i2 < rowkeySize) {
            ObObj obObj = new ObObj();
            ObTableSerialUtil.decode(buf, obObj);
            endKey.addObj(obObj);
            ++i2;
        }
        range.setEndKey(endKey);
        if (ObGlobal.obVsnMajor() >= 4) {
            range.setFlag(Serialization.decodeVi64(buf));
        }
    }
}

