/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.Credentialable;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableConsistencyLevel;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOptionFlag;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import com.alipay.oceanbase.rpc.util.Serialization;

public abstract class ObTableAbstractOperationRequest
extends AbstractPayload
implements Credentialable {
    protected ObBytesString credential;
    protected String tableName;
    protected long tableId = -1L;
    protected long partitionId = 0L;
    protected ObTableEntityType entityType = ObTableEntityType.KV;
    protected ObTableConsistencyLevel consistencyLevel = ObTableConsistencyLevel.STRONG;
    protected ObTableOptionFlag option_flag = ObTableOptionFlag.DEFAULT;
    protected boolean returningAffectedEntity = false;
    protected boolean returningAffectedRows = false;

    @Override
    public long getPayloadContentSize() {
        if (ObGlobal.obVsnMajor() >= 4) {
            return Serialization.getNeedBytes(this.credential) + Serialization.getNeedBytes(this.tableName) + Serialization.getNeedBytes(this.tableId) + 8 + 2 + 3;
        }
        return Serialization.getNeedBytes(this.credential) + Serialization.getNeedBytes(this.tableName) + Serialization.getNeedBytes(this.tableId) + Serialization.getNeedBytes(this.partitionId) + 2 + 3;
    }

    protected int encodeCredential(byte[] bytes, int idx) {
        byte[] strbytes = Serialization.encodeBytesString(this.credential);
        System.arraycopy(strbytes, 0, bytes, idx, strbytes.length);
        return idx += strbytes.length;
    }

    protected int encodeTableMetaWithPartitionId(byte[] bytes, int idx) {
        byte[] strbytes = Serialization.encodeVString(this.tableName);
        System.arraycopy(strbytes, 0, bytes, idx, strbytes.length);
        int len = Serialization.getNeedBytes(this.tableId);
        System.arraycopy(Serialization.encodeVi64(this.tableId), 0, bytes, idx += strbytes.length, len);
        idx += len;
        if (ObGlobal.obVsnMajor() >= 4) {
            System.arraycopy(Serialization.encodeI64(this.partitionId), 0, bytes, idx, 8);
            idx += 8;
        } else {
            len = Serialization.getNeedBytes(this.partitionId);
            System.arraycopy(Serialization.encodeVi64(this.partitionId), 0, bytes, idx, len);
            idx += len;
        }
        System.arraycopy(Serialization.encodeI8(this.entityType.getByteValue()), 0, bytes, idx, 1);
        return ++idx;
    }

    protected int encodeTableMetaWithoutPartitionId(byte[] bytes, int idx) {
        byte[] strbytes = Serialization.encodeVString(this.tableName);
        System.arraycopy(strbytes, 0, bytes, idx, strbytes.length);
        int len = Serialization.getNeedBytes(this.tableId);
        System.arraycopy(Serialization.encodeVi64(this.tableId), 0, bytes, idx += strbytes.length, len);
        System.arraycopy(Serialization.encodeI8(this.entityType.getByteValue()), 0, bytes, idx += len, 1);
        return ++idx;
    }

    protected int encodeConsistencyLevel(byte[] bytes, int idx) {
        System.arraycopy(Serialization.encodeI8(this.consistencyLevel.getByteValue()), 0, bytes, idx, 1);
        return ++idx;
    }

    public ObBytesString getCredential() {
        return this.credential;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public void setCredential(ObBytesString credential) {
        this.credential = credential;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public long getTableId() {
        return this.tableId;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(long partitionId) {
        this.partitionId = partitionId;
    }

    public ObTableEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(ObTableEntityType entityType) {
        this.entityType = entityType;
    }

    public ObTableConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ObTableConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public void setOptionFlag(ObTableOptionFlag optionFlagflag) {
        this.option_flag = optionFlagflag;
    }

    public boolean isReturningAffectedEntity() {
        return this.returningAffectedEntity;
    }

    public void setReturningAffectedEntity(boolean returningAffectedEntity) {
        this.returningAffectedEntity = returningAffectedEntity;
    }

    public boolean isReturningAffectedRows() {
        return this.returningAffectedRows;
    }

    public void setReturningAffectedRows(boolean returningAffectedRows) {
        this.returningAffectedRows = returningAffectedRows;
    }
}

