/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.Credentialable;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableConsistencyLevel;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableLSOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableTabletOp;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObTableLSOpRequest
extends AbstractPayload
implements Credentialable {
    protected ObBytesString credential;
    protected ObTableEntityType entityType = ObTableEntityType.KV;
    protected ObTableConsistencyLevel consistencyLevel = ObTableConsistencyLevel.STRONG;
    private ObTableLSOperation lsOperation = null;

    @Override
    public int getPcode() {
        return 4389;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        byte[] strbytes = Serialization.encodeBytesString(this.credential);
        System.arraycopy(strbytes, 0, bytes, idx, strbytes.length);
        System.arraycopy(Serialization.encodeI8(this.entityType.getByteValue()), 0, bytes, idx += strbytes.length, 1);
        System.arraycopy(Serialization.encodeI8(this.consistencyLevel.getByteValue()), 0, bytes, ++idx, 1);
        int len = (int)this.lsOperation.getPayloadSize();
        System.arraycopy(this.lsOperation.encode(), 0, bytes, ++idx, len);
        idx += len;
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.credential = Serialization.decodeBytesString(buf);
        this.entityType = ObTableEntityType.valueOf(buf.readByte());
        this.consistencyLevel = ObTableConsistencyLevel.valueOf(buf.readByte());
        this.lsOperation = new ObTableLSOperation();
        this.lsOperation.decode(buf);
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        return this.lsOperation.getPayloadSize() + (long)Serialization.getNeedBytes(this.credential) + 1L + 1L;
    }

    public ObTableLSOperation getLSOperation() {
        return this.lsOperation;
    }

    public void addTabletOperation(ObTableTabletOp tabletOp) {
        this.lsOperation.addTabletOperation(tabletOp);
    }

    public void setLsOperation(ObTableLSOperation lsOperation) {
        this.lsOperation = lsOperation;
    }

    public void setEntityType(ObTableEntityType entityType) {
        this.entityType = entityType;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setConsistencyLevel(ObTableConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    @Override
    public void setCredential(ObBytesString credential) {
        this.credential = credential;
    }

    public void setTableId(long tableId) {
        this.lsOperation.setTableId(tableId);
    }
}

