/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableLSOpFlag;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOp;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpEntity;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableTabletOp;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObTableLSOperation
extends AbstractPayload {
    private List<ObTableTabletOp> tabletOperations = new ArrayList<ObTableTabletOp>();
    private long lsId = -1L;
    private String tableName;
    private long tableId = -1L;
    private List<String> rowKeyNames = new ArrayList<String>();
    private Set<String> rowKeyNamesSet = new LinkedHashSet<String>();
    private Map<String, Long> rowkeyColumnNamesIdxMap = new HashMap<String, Long>();
    private List<String> propertiesNames = new ArrayList<String>();
    private Set<String> propertiesNamesSet = new LinkedHashSet<String>();
    private Map<String, Long> propertiesColumnNamesIdxMap = new HashMap<String, Long>();
    private ObTableLSOpFlag optionFlag = new ObTableLSOpFlag();
    private static final int LS_ID_SIZE = 8;
    private static final long INVALID_LS_ID = -1L;

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        System.arraycopy(Serialization.encodeI64(this.lsId), 0, bytes, idx, 8);
        int len = Serialization.getNeedBytes(this.tableName);
        System.arraycopy(Serialization.encodeVString(this.tableName), 0, bytes, idx += 8, len);
        idx += len;
        len = Serialization.getNeedBytes(this.tableId);
        System.arraycopy(Serialization.encodeVi64(this.tableId), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.rowKeyNames.size());
        System.arraycopy(Serialization.encodeVi64(this.rowKeyNames.size()), 0, bytes, idx, len);
        idx += len;
        for (String rowKeyName : this.rowKeyNames) {
            len = Serialization.getNeedBytes(rowKeyName);
            System.arraycopy(Serialization.encodeVString(rowKeyName), 0, bytes, idx, len);
            idx += len;
        }
        len = Serialization.getNeedBytes(this.propertiesNames.size());
        System.arraycopy(Serialization.encodeVi64(this.propertiesNames.size()), 0, bytes, idx, len);
        idx += len;
        for (String propertyName : this.propertiesNames) {
            len = Serialization.getNeedBytes(propertyName);
            System.arraycopy(Serialization.encodeVString(propertyName), 0, bytes, idx, len);
            idx += len;
        }
        len = Serialization.getNeedBytes(this.optionFlag.getValue());
        System.arraycopy(Serialization.encodeVi64(this.optionFlag.getValue()), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.tabletOperations.size());
        System.arraycopy(Serialization.encodeVi64(this.tabletOperations.size()), 0, bytes, idx, len);
        idx += len;
        for (ObTableTabletOp tabletOperation : this.tabletOperations) {
            len = (int)tabletOperation.getPayloadSize();
            System.arraycopy(tabletOperation.encode(), 0, bytes, idx, len);
            idx += len;
        }
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        int i;
        super.decode(buf);
        this.lsId = Serialization.decodeI64(buf);
        this.tableName = Serialization.decodeVString(buf);
        this.tableId = Serialization.decodeVi64(buf);
        int len = (int)Serialization.decodeVi64(buf);
        for (i = 0; i < len; ++i) {
            String rowkeyName = Serialization.decodeVString(buf);
            this.rowKeyNames.add(rowkeyName);
        }
        len = (int)Serialization.decodeVi64(buf);
        for (i = 0; i < len; ++i) {
            String propertyName = Serialization.decodeVString(buf);
            this.propertiesNames.add(propertyName);
        }
        long flagValue = Serialization.decodeVi64(buf);
        this.optionFlag.setValue(flagValue);
        len = (int)Serialization.decodeVi64(buf);
        this.tabletOperations = new ArrayList<ObTableTabletOp>(len);
        for (int i2 = 0; i2 < len; ++i2) {
            ObTableTabletOp tabletOperation = new ObTableTabletOp();
            tabletOperation.decode(buf);
            this.tabletOperations.add(tabletOperation);
        }
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        long payloadContentSize = 0L;
        payloadContentSize += (long)Serialization.getNeedBytes(this.tabletOperations.size());
        for (ObTableTabletOp operation : this.tabletOperations) {
            payloadContentSize += operation.getPayloadSize();
        }
        payloadContentSize += (long)Serialization.getNeedBytes(this.rowKeyNames.size());
        for (String rowKeyName : this.rowKeyNames) {
            payloadContentSize += (long)Serialization.getNeedBytes(rowKeyName);
        }
        payloadContentSize += (long)Serialization.getNeedBytes(this.propertiesNames.size());
        for (String propertyName : this.propertiesNames) {
            payloadContentSize += (long)Serialization.getNeedBytes(propertyName);
        }
        return payloadContentSize + 8L + (long)Serialization.getNeedBytes(this.optionFlag.getValue()) + (long)Serialization.getNeedBytes(this.tableName) + (long)Serialization.getNeedBytes(this.tableId);
    }

    public List<ObTableTabletOp> getTabletOperations() {
        return this.tabletOperations;
    }

    public void addTabletOperation(ObTableTabletOp tabletOperation) {
        this.tabletOperations.add(tabletOperation);
        int length = this.tabletOperations.size();
        this.rowKeyNamesSet.addAll(tabletOperation.getRowKeyNamesSet());
        this.propertiesNamesSet.addAll(tabletOperation.getPropertiesNamesSet());
        if (length == 1 && tabletOperation.isSameType()) {
            this.setIsSameType(true);
            return;
        }
        if (this.isSameType() && length > 1 && (!tabletOperation.isSameType() || this.tabletOperations.get(length - 1).getSingleOperations().get(0).getSingleOpType() != this.tabletOperations.get(length - 2).getSingleOperations().get(0).getSingleOpType())) {
            this.setIsSameType(false);
        }
    }

    public void setLsId(long lsId) {
        this.lsId = lsId;
    }

    public void setReturnOneResult(boolean returnOneResult) {
        this.optionFlag.setReturnOneResult(returnOneResult);
    }

    public boolean isSameType() {
        return this.optionFlag.getFlagIsSameType();
    }

    public void setIsSameType(boolean isSameType) {
        this.optionFlag.setFlagIsSameType(isSameType);
    }

    public boolean isSamePropertiesNames() {
        return this.optionFlag.getFlagIsSamePropertiesNames();
    }

    public void setIsSamePropertiesNames(boolean isSamePropertiesNames) {
        this.optionFlag.setFlagIsSamePropertiesNames(isSamePropertiesNames);
    }

    public void setNeedAllProp(boolean needAllProp) {
        this.optionFlag.setFlagNeedAllProp(needAllProp);
    }

    public boolean isNeedAllProp() {
        return this.optionFlag.getFlagNeedAllProp();
    }

    public long getTableId() {
        return this.tableId;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }

    public void prepareOption() {
        if (this.isSamePropertiesNames()) {
            for (ObTableTabletOp tabletOp : this.tabletOperations) {
                for (ObTableSingleOp singleOp : tabletOp.getSingleOperations()) {
                    for (ObTableSingleOpEntity entity : singleOp.getEntities()) {
                        entity.setIgnoreEncodePropertiesColumnNames(true);
                    }
                }
            }
        }
    }

    public void collectColumnNamesIdxMap() {
        long index = 0L;
        for (String rowkeyName : this.rowKeyNamesSet) {
            this.rowKeyNames.add(rowkeyName);
            this.rowkeyColumnNamesIdxMap.put(rowkeyName, index);
            ++index;
        }
        index = 0L;
        for (String propertiesName : this.propertiesNamesSet) {
            this.propertiesNames.add(propertiesName);
            this.propertiesColumnNamesIdxMap.put(propertiesName, index);
            ++index;
        }
    }

    public void beforeOption() {
        boolean isSamePropertiesColumnNames = true;
        for (ObTableTabletOp tabletOp : this.tabletOperations) {
            for (ObTableSingleOp singleOp : tabletOp.getSingleOperations()) {
                ObTableSingleOpEntity entity;
                Iterator<ObTableSingleOpEntity> iterator = singleOp.getEntities().iterator();
                while (iterator.hasNext() && (isSamePropertiesColumnNames = (entity = iterator.next()).isSamePropertiesColumnNamesLen(this.propertiesColumnNamesIdxMap.size()))) {
                }
                if (isSamePropertiesColumnNames) continue;
                break;
            }
            if (isSamePropertiesColumnNames) continue;
            break;
        }
        if (isSamePropertiesColumnNames) {
            this.setIsSamePropertiesNames(true);
        }
    }

    public void prepareColumnNamesBitMap() {
        for (ObTableTabletOp tabletOp : this.tabletOperations) {
            for (ObTableSingleOp singleOp : tabletOp.getSingleOperations()) {
                singleOp.getQuery().adjustScanRangeColumns(this.rowkeyColumnNamesIdxMap);
                for (ObTableSingleOpEntity entity : singleOp.getEntities()) {
                    entity.adjustRowkeyColumnName(this.rowkeyColumnNamesIdxMap);
                    entity.adjustPropertiesColumnName(this.propertiesColumnNamesIdxMap);
                }
            }
        }
    }

    public void prepare() {
        this.collectColumnNamesIdxMap();
        this.beforeOption();
        this.prepareOption();
        this.prepareColumnNamesBitMap();
    }

    public long getLsId() {
        return this.lsId;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

