/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.location.model.ObReplicaType;
import com.alipay.oceanbase.rpc.location.model.ObServerRole;
import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObAddr;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObTableMoveReplicaInfo
extends AbstractPayload {
    private long tableId;
    private long schemaVersion;
    private long partitionId;
    private ObAddr server = new ObAddr();
    private ObServerRole obServerRole;
    private ObReplicaType obReplicaType;
    private long partRenewTime;
    private long reserved;

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        System.arraycopy(Serialization.encodeVi64(this.tableId), 0, bytes, idx, Serialization.getNeedBytes(this.tableId));
        System.arraycopy(Serialization.encodeVi64(this.schemaVersion), 0, bytes, idx, Serialization.getNeedBytes(this.schemaVersion));
        if (ObGlobal.OB_VERSION >= 4L) {
            System.arraycopy(Serialization.encodeI64(this.partitionId), 0, bytes, idx, Serialization.getNeedBytes(this.partitionId));
        } else {
            System.arraycopy(Serialization.encodeVi64(this.partitionId), 0, bytes, idx, Serialization.getNeedBytes(this.partitionId));
        }
        System.arraycopy(this.server.encode(), 0, bytes, idx, Serialization.getNeedBytes(this.server.encode()));
        System.arraycopy(Serialization.encodeVi32(this.obServerRole.getIndex()), 0, bytes, idx, Serialization.getNeedBytes(this.obServerRole.getIndex()));
        System.arraycopy(Serialization.encodeVi32(this.obReplicaType.getIndex()), 0, bytes, idx, Serialization.getNeedBytes(this.obReplicaType.getIndex()));
        System.arraycopy(Serialization.encodeVi64(this.partRenewTime), 0, bytes, idx, Serialization.getNeedBytes(this.partRenewTime));
        System.arraycopy(Serialization.encodeVi64(this.reserved), 0, bytes, idx, Serialization.getNeedBytes(this.reserved));
        return bytes;
    }

    @Override
    public long getPayloadContentSize() {
        return 0L;
    }

    public ObAddr getServer() {
        return this.server;
    }

    @Override
    public ObTableMoveReplicaInfo decode(ByteBuf buf) {
        super.decode(buf);
        this.tableId = Serialization.decodeVi64(buf);
        this.schemaVersion = Serialization.decodeVi64(buf);
        this.partitionId = ObGlobal.OB_VERSION >= 4L ? Serialization.decodeI64(buf) : Serialization.decodeVi64(buf);
        this.server.decode(buf);
        this.obServerRole = ObServerRole.getRole(Serialization.decodeI8(buf));
        this.obReplicaType = ObReplicaType.getReplicaType(Serialization.decodeVi32(buf));
        this.partRenewTime = Serialization.decodeVi64(buf);
        this.reserved = Serialization.decodeVi64(buf);
        return this;
    }
}

