/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableAbstractOperationRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableConsistencyLevel;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntity;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOptionFlag;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObTableOperationRequest
extends ObTableAbstractOperationRequest {
    private ObTableOperation tableOperation;

    @Override
    public int getPcode() {
        return 4354;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        idx = this.encodeCredential(bytes, idx);
        idx = this.encodeTableMetaWithPartitionId(bytes, idx);
        int len = (int)this.tableOperation.getPayloadSize();
        System.arraycopy(this.tableOperation.encode(), 0, bytes, idx, len);
        System.arraycopy(Serialization.encodeI8(this.consistencyLevel.getByteValue()), 0, bytes, idx += len, 1);
        System.arraycopy(Serialization.encodeI8(this.option_flag.getByteValue()), 0, bytes, ++idx, 1);
        System.arraycopy(Serialization.encodeI8(this.returningAffectedEntity ? (byte)1 : 0), 0, bytes, ++idx, 1);
        System.arraycopy(Serialization.encodeI8(this.returningAffectedRows ? (byte)1 : 0), 0, bytes, ++idx, 1);
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.credential = Serialization.decodeBytesString(buf);
        this.tableName = Serialization.decodeVString(buf);
        this.tableId = Serialization.decodeVi64(buf);
        this.partitionId = ObGlobal.obVsnMajor() >= 4 ? Serialization.decodeI64(buf) : Serialization.decodeVi64(buf);
        this.entityType = ObTableEntityType.valueOf(buf.readByte());
        this.tableOperation = new ObTableOperation();
        if (!ObTableEntityType.DYNAMIC.equals((Object)this.entityType)) {
            throw new IllegalArgumentException();
        }
        this.tableOperation.setEntity(new ObTableEntity());
        this.tableOperation.decode(buf);
        this.consistencyLevel = ObTableConsistencyLevel.valueOf(buf.readByte());
        this.option_flag = ObTableOptionFlag.valueOf(buf.readByte());
        this.returningAffectedEntity = Serialization.decodeI8(buf) != 0;
        this.returningAffectedRows = Serialization.decodeI8(buf) != 0;
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        return super.getPayloadContentSize() + this.tableOperation.getPayloadSize();
    }

    public ObTableOperation getTableOperation() {
        return this.tableOperation;
    }

    public void setTableOperation(ObTableOperation tableOperation) {
        this.tableOperation = tableOperation;
    }

    public static ObTableOperationRequest getInstance(String tableName, ObTableOperationType type, Object[] rowKeys, String[] columns, Object[] properties, long timeout) {
        ObTableOperationRequest request = new ObTableOperationRequest();
        request.setTableName(tableName);
        request.setTimeout(timeout);
        request.setReturningAffectedRows(true);
        ObTableOperation obTableOperation = ObTableOperation.getInstance(type, rowKeys, columns, properties);
        request.setTableOperation(obTableOperation);
        return request;
    }
}

