/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpEntity;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpFlag;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpQuery;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class ObTableSingleOp
extends AbstractPayload {
    private ObTableOperationType singleOpType;
    private ObTableSingleOpFlag singleOpFlag = new ObTableSingleOpFlag();
    private ObTableSingleOpQuery query = new ObTableSingleOpQuery();
    private List<ObTableSingleOpEntity> entities = new ArrayList<ObTableSingleOpEntity>();

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        byte opTypeVal = this.singleOpType.getByteValue();
        System.arraycopy(Serialization.encodeI8(opTypeVal), 0, bytes, idx, 1);
        long flag = this.singleOpFlag.getValue();
        int len = Serialization.getNeedBytes(flag);
        System.arraycopy(Serialization.encodeVi64(flag), 0, bytes, ++idx, len);
        idx += len;
        if (ObTableOperationType.needEncodeQuery(this.singleOpType)) {
            len = (int)this.query.getPayloadSize();
            System.arraycopy(this.query.encode(), 0, bytes, idx, len);
            idx += len;
        }
        len = Serialization.getNeedBytes(this.entities.size());
        System.arraycopy(Serialization.encodeVi64(this.entities.size()), 0, bytes, idx, len);
        idx += len;
        for (ObTableSingleOpEntity entity : this.entities) {
            len = (int)entity.getPayloadSize();
            System.arraycopy(entity.encode(), 0, bytes, idx, len);
            idx += len;
        }
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.singleOpType = ObTableOperationType.valueOf(Serialization.decodeI8(buf.readByte()));
        this.singleOpFlag.setValue(Serialization.decodeVi64(buf));
        if (ObTableOperationType.needEncodeQuery(this.singleOpType)) {
            this.query.decode(buf);
        }
        int len = (int)Serialization.decodeVi64(buf);
        for (int i = 0; i < len; ++i) {
            ObTableSingleOpEntity entity = new ObTableSingleOpEntity();
            entity.decode(buf);
            this.entities.add(entity);
        }
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        long payloadContentSize = Serialization.getNeedBytes(this.singleOpType.getByteValue());
        payloadContentSize += (long)Serialization.getNeedBytes(this.singleOpFlag.getValue());
        if (ObTableOperationType.needEncodeQuery(this.singleOpType)) {
            payloadContentSize += this.query.getPayloadSize();
        }
        payloadContentSize += (long)Serialization.getNeedBytes(this.entities.size());
        for (ObTableSingleOpEntity entity : this.entities) {
            payloadContentSize += entity.getPayloadSize();
        }
        return payloadContentSize;
    }

    public List<ObNewRange> getScanRange() {
        return this.query.getScanRanges();
    }

    public void addScanRange(ObNewRange range) {
        this.addScanRange(range);
    }

    public void setIsCheckNoExists(boolean isCheckNoExists) {
        this.singleOpFlag.setIsCheckNotExists(isCheckNoExists);
    }

    public ObTableOperationType getSingleOpType() {
        return this.singleOpType;
    }

    public void setSingleOpType(ObTableOperationType singleOpType) {
        this.singleOpType = singleOpType;
    }

    public ObTableSingleOpQuery getQuery() {
        return this.query;
    }

    public void setQuery(ObTableSingleOpQuery query) {
        this.query = query;
    }

    public List<ObTableSingleOpEntity> getEntities() {
        return this.entities;
    }

    public void setEntities(List<ObTableSingleOpEntity> entities) {
        this.entities = entities;
    }

    public void addEntity(ObTableSingleOpEntity entity) {
        this.entities.add(entity);
    }

    public List<ObObj> getRowkeyObjs() {
        if (this.singleOpType == ObTableOperationType.SCAN) {
            throw new IllegalArgumentException("can not get rowkey from scan operation");
        }
        List<ObObj> rowkeyObjs = this.singleOpType == ObTableOperationType.CHECK_AND_INSERT_UP ? this.getScanRange().get(0).getStartKey().getObjs() : this.entities.get(0).getRowkey();
        return rowkeyObjs;
    }
}

