/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query;

import com.alipay.oceanbase.rpc.exception.FeatureNotSupportedException;
import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.aggregation.ObTableAggregationSingle;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.aggregation.ObTableAggregationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObHTableFilter;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObScanOrder;
import com.alipay.oceanbase.rpc.table.ObHBaseParams;
import com.alipay.oceanbase.rpc.table.ObKVParams;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;

public class ObTableQuery
extends AbstractPayload {
    private List<ObNewRange> keyRanges = new LinkedList<ObNewRange>();
    private List<String> selectColumns = new LinkedList<String>();
    private String filterString;
    private int limit = -1;
    private int offset = 0;
    private ObScanOrder scanOrder = ObScanOrder.Forward;
    private String indexName;
    private int batchSize = -1;
    private long maxResultSize = -1L;
    private ObHTableFilter hTableFilter;
    private static final byte[] HTABLE_DUMMY_BYTES = new byte[]{1, 0};
    private boolean isHbaseQuery = false;
    private List<String> scanRangeColumns = new LinkedList<String>();
    private List<ObTableAggregationSingle> aggregations = new LinkedList<ObTableAggregationSingle>();
    private ObKVParams obKVParams;

    public boolean isFilterNull() {
        return this.filterString != null;
    }

    public boolean isAggregation() {
        return !this.aggregations.isEmpty();
    }

    public void addAggregation(ObTableAggregationType aggType, String aggColumn) {
        this.aggregations.add(new ObTableAggregationSingle(aggType, aggColumn));
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        int headerLen = (int)Serialization.getObUniVersionHeaderLength(this.getVersion(), this.getPayloadContentSize());
        System.arraycopy(Serialization.encodeObUniVersionHeader(this.getVersion(), this.getPayloadContentSize()), 0, bytes, idx, headerLen);
        int len = Serialization.getNeedBytes(this.keyRanges.size());
        System.arraycopy(Serialization.encodeVi64(this.keyRanges.size()), 0, bytes, idx += headerLen, len);
        idx += len;
        for (ObNewRange keyRange : this.keyRanges) {
            len = keyRange.getEncodedSize();
            System.arraycopy(keyRange.encode(), 0, bytes, idx, len);
            idx += len;
        }
        len = Serialization.getNeedBytes(this.selectColumns.size());
        System.arraycopy(Serialization.encodeVi64(this.selectColumns.size()), 0, bytes, idx, len);
        idx += len;
        for (String selectColumn : this.selectColumns) {
            len = Serialization.getNeedBytes(selectColumn);
            System.arraycopy(Serialization.encodeVString(selectColumn), 0, bytes, idx, len);
            idx += len;
        }
        len = Serialization.getNeedBytes(this.filterString);
        System.arraycopy(Serialization.encodeVString(this.filterString), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.limit);
        System.arraycopy(Serialization.encodeVi32(this.limit), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.offset);
        System.arraycopy(Serialization.encodeVi32(this.offset), 0, bytes, idx, len);
        System.arraycopy(Serialization.encodeI8(this.scanOrder.getByteValue()), 0, bytes, idx += len, 1);
        len = Serialization.getNeedBytes(this.indexName);
        System.arraycopy(Serialization.encodeVString(this.indexName), 0, bytes, ++idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.batchSize);
        System.arraycopy(Serialization.encodeVi32(this.batchSize), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.maxResultSize);
        System.arraycopy(Serialization.encodeVi64(this.maxResultSize), 0, bytes, idx, len);
        idx += len;
        if (this.isHbaseQuery) {
            len = (int)this.hTableFilter.getPayloadSize();
            System.arraycopy(this.hTableFilter.encode(), 0, bytes, idx, len);
        } else {
            len = HTABLE_DUMMY_BYTES.length;
            System.arraycopy(HTABLE_DUMMY_BYTES, 0, bytes, idx, len);
        }
        idx += len;
        len = Serialization.getNeedBytes(this.scanRangeColumns.size());
        System.arraycopy(Serialization.encodeVi64(this.scanRangeColumns.size()), 0, bytes, idx, len);
        idx += len;
        for (String keyRangeColumn : this.scanRangeColumns) {
            len = Serialization.getNeedBytes(keyRangeColumn);
            System.arraycopy(Serialization.encodeVString(keyRangeColumn), 0, bytes, idx, len);
            idx += len;
        }
        len = Serialization.getNeedBytes(this.aggregations.size());
        System.arraycopy(Serialization.encodeVi64(this.aggregations.size()), 0, bytes, idx, len);
        idx += len;
        for (ObTableAggregationSingle obTableAggregationSingle : this.aggregations) {
            len = (int)obTableAggregationSingle.getPayloadSize();
            System.arraycopy(obTableAggregationSingle.encode(), 0, bytes, idx, len);
            idx += len;
        }
        if (this.isHbaseQuery && this.obKVParams != null) {
            len = (int)this.obKVParams.getPayloadSize();
            System.arraycopy(this.obKVParams.encode(), 0, bytes, idx, len);
            idx += len;
        } else {
            len = HTABLE_DUMMY_BYTES.length;
            System.arraycopy(HTABLE_DUMMY_BYTES, 0, bytes, idx, len);
            idx += len;
        }
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        long size = Serialization.decodeVi64(buf);
        int i = 0;
        while ((long)i < size) {
            ObNewRange obNewRange = new ObNewRange();
            obNewRange.decode(buf);
            this.keyRanges.add(obNewRange);
            ++i;
        }
        size = Serialization.decodeVi64(buf);
        i = 0;
        while ((long)i < size) {
            this.selectColumns.add(Serialization.decodeVString(buf));
            ++i;
        }
        this.filterString = Serialization.decodeVString(buf);
        this.limit = Serialization.decodeVi32(buf);
        this.offset = Serialization.decodeVi32(buf);
        this.scanOrder = ObScanOrder.valueOf(Serialization.decodeI8(buf));
        this.indexName = Serialization.decodeVString(buf);
        this.batchSize = Serialization.decodeVi32(buf);
        this.maxResultSize = Serialization.decodeVi64(buf);
        buf.markReaderIndex();
        buf.readByte();
        if (Serialization.decodeVi64(buf) > 0L) {
            buf.resetReaderIndex();
            this.isHbaseQuery = true;
            this.hTableFilter = new ObHTableFilter();
            this.hTableFilter.decode(buf);
        } else {
            buf.resetReaderIndex();
            buf.readByte();
            buf.readByte();
        }
        size = Serialization.decodeVi64(buf);
        i = 0;
        while ((long)i < size) {
            this.scanRangeColumns.add(Serialization.decodeVString(buf));
            ++i;
        }
        size = Serialization.decodeVi64(buf);
        i = 0;
        while ((long)i < size) {
            byte agg_type = Serialization.decodeI8(buf);
            String agg_column = Serialization.decodeVString(buf);
            this.aggregations.add(new ObTableAggregationSingle(ObTableAggregationType.fromByte(agg_type), agg_column));
            ++i;
        }
        if (this.isHbaseQuery) {
            this.obKVParams = new ObKVParams();
            this.obKVParams.decode(buf);
        }
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        long contentSize = 0L;
        contentSize += (long)Serialization.getNeedBytes(this.keyRanges.size());
        for (ObNewRange obNewRange : this.keyRanges) {
            contentSize += (long)obNewRange.getEncodedSize();
        }
        contentSize += (long)Serialization.getNeedBytes(this.selectColumns.size());
        for (String selectColumn : this.selectColumns) {
            contentSize += (long)Serialization.getNeedBytes(selectColumn);
        }
        contentSize += (long)Serialization.getNeedBytes(this.filterString);
        contentSize += (long)Serialization.getNeedBytes(this.limit);
        contentSize += (long)Serialization.getNeedBytes(this.offset);
        ++contentSize;
        contentSize += (long)Serialization.getNeedBytes(this.indexName);
        contentSize += (long)Serialization.getNeedBytes(this.batchSize);
        contentSize += (long)Serialization.getNeedBytes(this.maxResultSize);
        contentSize = this.isHbaseQuery ? (contentSize += this.hTableFilter.getPayloadSize()) : (contentSize += (long)HTABLE_DUMMY_BYTES.length);
        contentSize = this.isHbaseQuery && this.obKVParams != null ? (contentSize += this.obKVParams.getPayloadSize()) : (contentSize += (long)HTABLE_DUMMY_BYTES.length);
        contentSize += (long)Serialization.getNeedBytes(this.scanRangeColumns.size());
        for (String scanRangeColumn : this.scanRangeColumns) {
            contentSize += (long)Serialization.getNeedBytes(scanRangeColumn);
        }
        contentSize += (long)Serialization.getNeedBytes(this.aggregations.size());
        for (ObTableAggregationSingle obTableAggregationSingle : this.aggregations) {
            contentSize += obTableAggregationSingle.getPayloadSize();
        }
        return contentSize;
    }

    public List<ObNewRange> getKeyRanges() {
        return this.keyRanges;
    }

    public void setKeyRanges(List<ObNewRange> keyRanges) {
        this.keyRanges = keyRanges;
    }

    public void addKeyRange(ObNewRange keyRange) {
        this.keyRanges.add(keyRange);
    }

    public List<String> getSelectColumns() {
        return this.selectColumns;
    }

    public void setSelectColumns(List<String> selectColumns) {
        this.selectColumns = selectColumns;
    }

    public void addSelectColumn(String selectColumn) {
        this.selectColumns.add(selectColumn);
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public ObScanOrder getScanOrder() {
        return this.scanOrder;
    }

    public void setScanOrder(ObScanOrder scanOrder) {
        this.scanOrder = scanOrder;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize > 0) {
            this.batchSize = batchSize;
        }
    }

    public long getMaxResultSize() {
        return this.maxResultSize;
    }

    public void setMaxResultSize(long maxResultSize) {
        if (maxResultSize > 0L) {
            this.maxResultSize = maxResultSize;
        }
    }

    public ObHTableFilter gethTableFilter() {
        return this.hTableFilter;
    }

    public void sethTableFilter(ObHTableFilter hTableFilter) {
        this.isHbaseQuery = true;
        this.hTableFilter = hTableFilter;
    }

    public boolean isHbaseQuery() {
        return this.isHbaseQuery;
    }

    public void setHbaseQuery(boolean hbaseQuery) {
        this.isHbaseQuery = hbaseQuery;
    }

    public List<String> getScanRangeColumns() {
        return this.scanRangeColumns;
    }

    public void setScanRangeColumns(String ... scanRangeColumns) {
        this.scanRangeColumns.clear();
        for (String scanRangeCol : scanRangeColumns) {
            this.scanRangeColumns.add(scanRangeCol);
        }
    }

    public void setScanRangeColumns(List<String> scanRangeColumns) {
        this.scanRangeColumns = scanRangeColumns;
    }

    public void setObKVParams(ObKVParams obKVParams) {
        if (!(obKVParams.getObParamsBase() instanceof ObHBaseParams)) {
            throw new FeatureNotSupportedException("only ObHBaseParams support currently");
        }
        this.isHbaseQuery = true;
        this.obKVParams = obKVParams;
    }

    public ObKVParams getObKVParams() {
        return this.obKVParams;
    }
}

