/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query;

import com.alipay.oceanbase.rpc.protocol.packet.ObRpcPacketHeader;
import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;

public class ObTableQueryResult
extends AbstractPayload {
    private ObRpcPacketHeader header;
    private List<String> propertiesNames = new LinkedList<String>();
    private long rowCount = 0L;
    private List<List<ObObj>> propertiesRows = new LinkedList<List<ObObj>>();

    public ObTableQueryResult() {
        this.header = new ObRpcPacketHeader();
    }

    public ObTableQueryResult(ObRpcPacketHeader header) {
        this.header = header;
    }

    @Override
    public int getPcode() {
        return 4356;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        int len = (int)Serialization.getObUniVersionHeaderLength(this.getVersion(), this.getPayloadSize());
        byte[] header = Serialization.encodeObUniVersionHeader(this.getVersion(), this.getPayloadSize());
        System.arraycopy(header, 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.propertiesNames.size());
        System.arraycopy(Serialization.encodeVi64(this.propertiesNames.size()), 0, bytes, idx, len);
        idx += len;
        for (String string : this.propertiesNames) {
            len = Serialization.getNeedBytes(string);
            System.arraycopy(Serialization.encodeVString(string), 0, bytes, idx, len);
            idx += len;
        }
        len = Serialization.getNeedBytes(this.rowCount);
        System.arraycopy(Serialization.encodeVi64(this.rowCount), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.propertiesRows.size());
        System.arraycopy(Serialization.encodeVi64(this.propertiesRows.size()), 0, bytes, idx, len);
        idx += len;
        for (List list : this.propertiesRows) {
            for (ObObj obObj : list) {
                len = obObj.getEncodedSize();
                System.arraycopy(obObj.encode(), 0, bytes, idx, len);
                idx += len;
            }
        }
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        long size = Serialization.decodeVi64(buf);
        int i = 0;
        while ((long)i < size) {
            this.propertiesNames.add(Serialization.decodeVString(buf));
            ++i;
        }
        this.rowCount = Serialization.decodeVi64(buf);
        Serialization.decodeVi64(buf);
        int r = 0;
        while ((long)r < this.rowCount) {
            LinkedList<ObObj> row = new LinkedList<ObObj>();
            for (int i2 = 0; i2 < this.propertiesNames.size(); ++i2) {
                ObObj obObj = new ObObj();
                obObj.decode(buf);
                row.add(obObj);
            }
            this.addPropertiesRow(row);
            ++r;
        }
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        long size = 0L;
        size += (long)Serialization.getNeedBytes(this.propertiesNames.size());
        for (String string : this.propertiesNames) {
            size += (long)Serialization.getNeedBytes(string);
        }
        size += (long)Serialization.getNeedBytes(this.rowCount);
        size += (long)Serialization.getNeedBytes(this.propertiesRows.size());
        for (List list : this.propertiesRows) {
            for (ObObj obObj : list) {
                size += (long)obObj.getEncodedSize();
            }
        }
        return size;
    }

    public List<String> getPropertiesNames() {
        return this.propertiesNames;
    }

    public void setPropertiesNames(List<String> propertiesNames) {
        this.propertiesNames = propertiesNames;
    }

    public void addPropertiesName(String propertiesName) {
        this.propertiesNames.add(propertiesName);
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    public List<List<ObObj>> getPropertiesRows() {
        return this.propertiesRows;
    }

    public void setPropertiesRows(List<List<ObObj>> propertiesRows) {
        this.propertiesRows = propertiesRows;
    }

    public void addPropertiesRow(List<ObObj> propertiesRow) {
        this.propertiesRows.add(propertiesRow);
    }

    public void addAllPropertiesRows(List<List<ObObj>> propertiesRows) {
        this.propertiesRows.addAll(propertiesRows);
    }

    public boolean isStream() {
        return this.header.isStream();
    }

    public boolean isStreamLast() {
        return this.header.isStreamLast();
    }

    public boolean isStreamNext() {
        return this.header.isStreamNext();
    }

    public long getSessionId() {
        return this.header.getSessionId();
    }
}

