/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.table.ObKVParamsBase;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObHBaseParams
extends ObKVParamsBase {
    int caching = -1;
    int callTimeout = -1;
    boolean allowPartialResults = true;
    boolean isCacheBlock = false;
    boolean checkExistenceOnly = false;
    private static final int FLAG_ALLOW_PARTIAL_RESULTS = 1;
    private static final int FLAG_IS_CACHE_BLOCK = 2;
    private static final int FLAG_CHECK_EXISTENCE_ONLY = 4;

    public ObHBaseParams() {
        this.pType = ObKVParamsBase.paramType.HBase;
    }

    @Override
    public ObKVParamsBase.paramType getType() {
        return this.pType;
    }

    public void setCaching(int caching) {
        this.caching = caching;
    }

    public void setCallTimeout(int callTimeout) {
        this.callTimeout = callTimeout;
    }

    public void setAllowPartialResults(boolean allowPartialResults) {
        this.allowPartialResults = allowPartialResults;
    }

    public void setCacheBlock(boolean isCacheBlock) {
        this.isCacheBlock = isCacheBlock;
    }

    public void setCheckExistenceOnly(boolean checkExistenceOnly) {
        this.checkExistenceOnly = checkExistenceOnly;
    }

    public int getCaching() {
        return this.caching;
    }

    public int getCallTimeout() {
        return this.callTimeout;
    }

    public boolean getAllowPartialResults() {
        return this.allowPartialResults;
    }

    public boolean getCacheBlock() {
        return this.isCacheBlock;
    }

    public boolean isCheckExistenceOnly() {
        return this.checkExistenceOnly;
    }

    public byte[] booleansToByteArray() {
        byte[] bytes = new byte[1];
        if (this.allowPartialResults) {
            bytes[0] = (byte)(bytes[0] | 1);
        }
        if (this.isCacheBlock) {
            bytes[0] = (byte)(bytes[0] | 2);
        }
        if (this.checkExistenceOnly) {
            bytes[0] = (byte)(bytes[0] | 4);
        }
        return bytes;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadContentSize()];
        int idx = 0;
        byte[] b = new byte[]{(byte)this.pType.ordinal()};
        System.arraycopy(b, 0, bytes, idx, 1);
        System.arraycopy(Serialization.encodeVi32(this.caching), 0, bytes, ++idx, Serialization.getNeedBytes(this.caching));
        System.arraycopy(Serialization.encodeVi32(this.callTimeout), 0, bytes, idx += Serialization.getNeedBytes(this.caching), Serialization.getNeedBytes(this.callTimeout));
        System.arraycopy(this.booleansToByteArray(), 0, bytes, idx += Serialization.getNeedBytes(this.callTimeout), 1);
        ++idx;
        return bytes;
    }

    public void byteArrayToBooleans(ByteBuf bytes) {
        byte b = bytes.readByte();
        this.allowPartialResults = (b & 1) != 0;
        this.isCacheBlock = (b & 2) != 0;
        this.checkExistenceOnly = (b & 4) != 0;
    }

    @Override
    public Object decode(ByteBuf buf) {
        this.caching = Serialization.decodeVi32(buf);
        this.callTimeout = Serialization.decodeVi32(buf);
        this.byteArrayToBooleans(buf);
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        return 1 + Serialization.getNeedBytes(this.caching) + Serialization.getNeedBytes(this.callTimeout) + 1;
    }

    public String toString() {
        return "ObParams: {\n pType = " + (Object)((Object)this.pType) + ", \n caching = " + this.caching + ", \n callTimeout = " + this.callTimeout + ", \n allowPartialResult = " + this.allowPartialResults + ", \n isCacheBlock = " + this.isCacheBlock + ", \n checkExistenceOnly = " + this.checkExistenceOnly + "\n}\n";
    }
}

