/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.table.ObHBaseParams;
import com.alipay.oceanbase.rpc.table.ObKVParamsBase;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObKVParams
extends AbstractPayload {
    public ObKVParamsBase obKVParamsBase;

    public ObKVParamsBase getObParams(ObKVParamsBase.paramType pType) {
        switch (pType) {
            case HBase: {
                return new ObHBaseParams();
            }
        }
        throw new RuntimeException("Currently does not support other types except HBase");
    }

    public void setObParamsBase(ObKVParamsBase obKVParamsBase) {
        this.obKVParamsBase = obKVParamsBase;
    }

    public ObKVParamsBase getObParamsBase() {
        return this.obKVParamsBase;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        int headerLen = (int)Serialization.getObUniVersionHeaderLength(this.getVersion(), this.getPayloadContentSize());
        System.arraycopy(Serialization.encodeObUniVersionHeader(this.getVersion(), this.getPayloadContentSize()), 0, bytes, idx, headerLen);
        int len = (int)this.obKVParamsBase.getPayloadContentSize();
        System.arraycopy(this.obKVParamsBase.encode(), 0, bytes, idx += headerLen, len);
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        byte b = buf.readByte();
        ObKVParamsBase.paramType pType = ObKVParamsBase.paramType.values()[b];
        this.obKVParamsBase = this.getObParams(pType);
        this.obKVParamsBase.decode(buf);
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        return this.obKVParamsBase.getPayloadContentSize();
    }
}

