/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.Lifecycle;
import com.alipay.oceanbase.rpc.bolt.transport.ObConnectionFactory;
import com.alipay.oceanbase.rpc.bolt.transport.ObPacketFactory;
import com.alipay.oceanbase.rpc.bolt.transport.ObTableConnection;
import com.alipay.oceanbase.rpc.bolt.transport.ObTableRemoting;
import com.alipay.oceanbase.rpc.checkandmutate.CheckAndInsUp;
import com.alipay.oceanbase.rpc.exception.ExceptionUtil;
import com.alipay.oceanbase.rpc.exception.ObTableConnectionStatusException;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTableServerConnectException;
import com.alipay.oceanbase.rpc.exception.ObTableTenantNotInServerException;
import com.alipay.oceanbase.rpc.filter.ObTableFilter;
import com.alipay.oceanbase.rpc.mutation.Append;
import com.alipay.oceanbase.rpc.mutation.BatchOperation;
import com.alipay.oceanbase.rpc.mutation.Delete;
import com.alipay.oceanbase.rpc.mutation.Increment;
import com.alipay.oceanbase.rpc.mutation.Insert;
import com.alipay.oceanbase.rpc.mutation.InsertOrUpdate;
import com.alipay.oceanbase.rpc.mutation.Put;
import com.alipay.oceanbase.rpc.mutation.Replace;
import com.alipay.oceanbase.rpc.mutation.Update;
import com.alipay.oceanbase.rpc.property.Property;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObITableEntity;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOptionFlag;
import com.alipay.oceanbase.rpc.table.AbstractObTable;
import com.alipay.oceanbase.rpc.table.ObTableBatchOpsImpl;
import com.alipay.oceanbase.rpc.table.api.TableBatchOps;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import com.alipay.remoting.ConnectionEventHandler;
import com.alipay.remoting.config.switches.GlobalSwitch;
import com.alipay.remoting.connection.ConnectionFactory;
import com.alipay.remoting.exception.RemotingException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObTable
extends AbstractObTable
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(ObTable.class);
    private String ip;
    private int port;
    private String tenantName;
    private String userName;
    private String password;
    private String database;
    private ConnectionFactory connectionFactory;
    private ObTableRemoting realClient;
    private ObTableConnectionPool connectionPool;
    private Map<String, Object> configs;
    private volatile boolean initialized = false;
    private volatile boolean closed = false;
    private boolean reRouting = true;
    private ReentrantLock statusLock = new ReentrantLock();

    @Override
    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        this.statusLock.lock();
        try {
            if (this.initialized) {
                return;
            }
            this.initProperties();
            this.init_check();
            this.connectionFactory = ObConnectionFactory.newBuilder().configWriteBufferWaterMark(this.getNettyBufferLowWatermark(), this.getNettyBufferHighWatermark()).build();
            this.connectionFactory.init(new ConnectionEventHandler(new GlobalSwitch()));
            this.realClient = new ObTableRemoting(new ObPacketFactory(this.reRouting));
            this.connectionPool = new ObTableConnectionPool(this, this.obTableConnectionPoolSize);
            this.connectionPool.init();
            this.initialized = true;
        }
        finally {
            this.statusLock.unlock();
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.statusLock.lock();
        try {
            if (this.closed) {
                return;
            }
            if (this.connectionPool != null) {
                this.connectionPool.close();
            }
            this.closed = true;
        }
        finally {
            this.statusLock.unlock();
        }
    }

    private void init_check() throws IllegalArgumentException {
        if (this.obTableConnectionPoolSize <= 0) {
            throw new IllegalArgumentException("invalid obTableConnectionPoolSize: " + this.obTableConnectionPoolSize);
        }
        if (this.ip.isEmpty() || this.port <= 0) {
            throw new IllegalArgumentException("invalid ip or port: " + this.ip + ":" + this.port);
        }
        if (this.userName.isEmpty() || this.database.isEmpty()) {
            throw new IllegalArgumentException("invalid userName or database: " + this.userName + ":" + this.database);
        }
    }

    private void checkStatus() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException(" database [" + this.database + "] in ip [" + this.ip + "] port [" + this.port + "]  username [" + this.userName + "] is not initialized");
        }
        if (this.closed) {
            throw new IllegalStateException(" database [" + this.database + "] in ip [" + this.ip + "] port [" + this.port + "]  username [" + this.userName + "] is closed");
        }
    }

    private void initProperties() {
        this.obTableConnectTimeout = this.parseToInt(Property.RPC_CONNECT_TIMEOUT.getKey(), this.obTableConnectTimeout);
        this.obTableConnectTryTimes = this.parseToInt(Property.RPC_CONNECT_TRY_TIMES.getKey(), this.obTableConnectTryTimes);
        this.obTableExecuteTimeout = this.parseToInt(Property.RPC_EXECUTE_TIMEOUT.getKey(), this.obTableExecuteTimeout);
        this.obTableLoginTimeout = this.parseToInt(Property.RPC_LOGIN_TIMEOUT.getKey(), this.obTableLoginTimeout);
        this.obTableLoginTryTimes = this.parseToInt(Property.RPC_LOGIN_TRY_TIMES.getKey(), this.obTableLoginTryTimes);
        this.obTableOperationTimeout = this.parseToLong(Property.RPC_OPERATION_TIMEOUT.getKey(), this.obTableOperationTimeout);
        this.obTableConnectionPoolSize = this.parseToInt(Property.SERVER_CONNECTION_POOL_SIZE.getKey(), this.obTableConnectionPoolSize);
        this.nettyBufferLowWatermark = this.parseToInt(Property.NETTY_BUFFER_LOW_WATERMARK.getKey(), this.nettyBufferLowWatermark);
        this.nettyBufferHighWatermark = this.parseToInt(Property.NETTY_BUFFER_HIGH_WATERMARK.getKey(), this.nettyBufferHighWatermark);
        this.nettyBlockingWaitInterval = this.parseToInt(Property.NETTY_BLOCKING_WAIT_INTERVAL.getKey(), this.nettyBlockingWaitInterval);
        this.reRouting = this.parseToBoolean(Property.SERVER_ENABLE_REROUTING.getKey(), this.reRouting);
        this.maxConnExpiredTime = this.parseToLong(Property.MAX_CONN_EXPIRED_TIME.getKey(), this.maxConnExpiredTime);
        Object value = this.configs.get("runtime");
        if (value instanceof Map) {
            Map runtimeMap = (Map)value;
            runtimeMap.put(Property.RPC_OPERATION_TIMEOUT.getKey(), String.valueOf(this.obTableOperationTimeout));
        }
    }

    public boolean getReRouting() {
        return this.reRouting;
    }

    @Override
    public TableQuery query(String tableName) throws Exception {
        throw new IllegalArgumentException("query using ObTable directly is not supported");
    }

    @Override
    public TableBatchOps batch(String tableName) {
        return new ObTableBatchOpsImpl(tableName, this);
    }

    @Override
    public Map<String, Object> get(String tableName, Object rowkey, String[] columns) throws RemotingException, InterruptedException {
        return this.get(tableName, new Object[]{rowkey}, columns);
    }

    @Override
    public Map<String, Object> get(String tableName, Object[] rowkeys, String[] columns) throws RemotingException, InterruptedException {
        ObTableOperationResult result = this.execute(tableName, ObTableOperationType.GET, rowkeys, columns, null, ObTableOptionFlag.DEFAULT, false, true);
        ObITableEntity entity = result.getEntity();
        return entity.getSimpleProperties();
    }

    @Override
    public Update update(String tableName) {
        return new Update(this, tableName);
    }

    @Override
    public long update(String tableName, Object[] rowkeys, String[] columns, Object[] values) throws RemotingException, InterruptedException {
        ObTableOperationResult result = this.execute(tableName, ObTableOperationType.UPDATE, rowkeys, columns, values, ObTableOptionFlag.DEFAULT, false, true);
        return result.getAffectedRows();
    }

    @Override
    public Delete delete(String tableName) {
        return new Delete(this, tableName);
    }

    @Override
    public long delete(String tableName, Object[] rowkeys) throws RemotingException, InterruptedException {
        ObTableOperationResult result = this.execute(tableName, ObTableOperationType.DEL, rowkeys, null, null, ObTableOptionFlag.DEFAULT, false, true);
        return result.getAffectedRows();
    }

    @Override
    public Insert insert(String tableName) {
        return new Insert(this, tableName);
    }

    @Override
    public long insert(String tableName, Object[] rowkeys, String[] columns, Object[] values) throws RemotingException, InterruptedException {
        ObTableOperationResult result = this.execute(tableName, ObTableOperationType.INSERT, rowkeys, columns, values, ObTableOptionFlag.DEFAULT, false, true);
        return result.getAffectedRows();
    }

    @Override
    public Replace replace(String tableName) {
        return new Replace(this, tableName);
    }

    @Override
    public long replace(String tableName, Object[] rowkeys, String[] columns, Object[] values) throws RemotingException, InterruptedException {
        ObTableOperationResult result = this.execute(tableName, ObTableOperationType.REPLACE, rowkeys, columns, values, ObTableOptionFlag.DEFAULT, false, true);
        return result.getAffectedRows();
    }

    @Override
    public InsertOrUpdate insertOrUpdate(String tableName) {
        return new InsertOrUpdate(this, tableName);
    }

    @Override
    public long insertOrUpdate(String tableName, Object[] rowkeys, String[] columns, Object[] values) throws RemotingException, InterruptedException {
        ObTableOperationResult result = this.execute(tableName, ObTableOperationType.INSERT_OR_UPDATE, rowkeys, columns, values, ObTableOptionFlag.DEFAULT, false, true);
        return result.getAffectedRows();
    }

    @Override
    public Put put(String tableName) {
        return new Put(this, tableName);
    }

    @Override
    public Increment increment(String tableName) {
        return new Increment(this, tableName);
    }

    @Override
    public Map<String, Object> increment(String tableName, Object[] rowkeys, String[] columns, Object[] values, boolean withResult) throws Exception {
        ObTableOperationResult result = this.execute(tableName, ObTableOperationType.INCREMENT, rowkeys, columns, values, ObTableOptionFlag.DEFAULT, withResult, true);
        ObITableEntity entity = result.getEntity();
        return entity.getSimpleProperties();
    }

    @Override
    public Append append(String tableName) {
        return new Append(this, tableName);
    }

    @Override
    public Map<String, Object> append(String tableName, Object[] rowkeys, String[] columns, Object[] values, boolean withResult) throws Exception {
        ObTableOperationResult result = this.execute(tableName, ObTableOperationType.APPEND, rowkeys, columns, values, ObTableOptionFlag.DEFAULT, withResult, true);
        ObITableEntity entity = result.getEntity();
        return entity.getSimpleProperties();
    }

    @Override
    public BatchOperation batchOperation(String tableName) {
        return new BatchOperation(this, tableName);
    }

    @Override
    public CheckAndInsUp checkAndInsUp(String tableName, ObTableFilter filter, InsertOrUpdate insUp, boolean checkExists) {
        return new CheckAndInsUp(this, tableName, filter, insUp, checkExists);
    }

    public ObTableOperationResult execute(String tableName, ObTableOperationType type, Object[] rowkeys, String[] columns, Object[] values, ObTableOptionFlag optionFlag, boolean returningAffectedEntity, boolean returningAffectedRows) throws RemotingException, InterruptedException {
        this.checkStatus();
        ObTableOperationRequest request = ObTableOperationRequest.getInstance(tableName, type, rowkeys, columns, values, this.obTableOperationTimeout);
        request.setOptionFlag(optionFlag);
        request.setReturningAffectedEntity(returningAffectedEntity);
        request.setReturningAffectedRows(returningAffectedRows);
        ObPayload result = this.execute(request);
        this.checkObTableOperationResult(this.ip, this.port, result);
        return (ObTableOperationResult)result;
    }

    public ObPayload execute(ObPayload request) throws RemotingException, InterruptedException {
        ObTableConnection connection = null;
        try {
            connection = this.getConnection();
            connection.checkStatus();
        }
        catch (ConnectException ex) {
            throw new ObTableServerConnectException(ex);
        }
        catch (ObTableServerConnectException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ObTableConnectionStatusException("check status failed", ex);
        }
        return this.executeWithReconnect(connection, request);
    }

    private ObPayload executeWithReconnect(ObTableConnection connection, ObPayload request) throws RemotingException, InterruptedException {
        boolean needReconnect = false;
        int retryTimes = 0;
        ObPayload payload = null;
        do {
            ++retryTimes;
            try {
                if (needReconnect) {
                    String msg = String.format("Receive error: tenant not in server and reconnect it, ip:{}, port:{}, tenant id:{}, retryTimes: {}", connection.getObTable().getIp(), connection.getObTable().getPort(), connection.getTenantId(), retryTimes);
                    connection.reConnectAndLogin(msg);
                    needReconnect = false;
                }
                payload = this.realClient.invokeSync(connection, request, this.obTableExecuteTimeout);
            }
            catch (ObTableException ex) {
                if (ex instanceof ObTableTenantNotInServerException && retryTimes < 2) {
                    needReconnect = true;
                    continue;
                }
                throw ex;
            }
        } while (needReconnect && retryTimes < 2);
        return payload;
    }

    public ObPayload executeWithConnection(ObPayload request, AtomicReference<ObTableConnection> connectionRef) throws RemotingException, InterruptedException {
        ObTableConnection connection;
        try {
            if (connectionRef.get() == null) {
                connection = this.getConnection();
                connectionRef.set(connection);
            }
            connection = connectionRef.get();
            connection.checkStatus();
        }
        catch (ConnectException ex) {
            throw new ObTableServerConnectException(ex);
        }
        catch (ObTableServerConnectException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ObTableConnectionStatusException("check status failed", ex);
        }
        return this.executeWithReconnect(connection, request);
    }

    private void checkObTableOperationResult(String ip, int port, Object result) {
        if (result == null) {
            throw new ObTableException("client get unexpected NULL result");
        }
        if (!(result instanceof ObTableOperationResult)) {
            throw new ObTableException("client get unexpected result: " + result.getClass().getName());
        }
        ObTableOperationResult obTableOperationResult = (ObTableOperationResult)result;
        ((ObTableOperationResult)result).setExecuteHost(ip);
        ((ObTableOperationResult)result).setExecutePort(port);
        ExceptionUtil.throwObTableException(ip, port, obTableOperationResult.getSequence(), obTableOperationResult.getUniqueId(), obTableOperationResult.getHeader().getErrno(), obTableOperationResult.getHeader().getErrMsg());
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setConfigs(Map<String, Object> configs) {
        this.configs = configs;
    }

    public Map<String, Object> getConfigs() {
        return this.configs;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ObTableRemoting getRealClient() {
        return this.realClient;
    }

    public void setRealClient(ObTableRemoting realClient) {
        this.realClient = realClient;
    }

    public ObTableConnection getConnection() throws Exception {
        int count;
        ObTableConnection conn = this.connectionPool.getConnection();
        for (count = 0; conn != null && conn.getConnection() != null && (conn.getCredential() == null || conn.getCredential().length() == 0) && count < this.obTableConnectionPoolSize; ++count) {
            conn = this.connectionPool.getConnection();
        }
        if (count == this.obTableConnectionPoolSize) {
            throw new ObTableException("all connection's credential is null");
        }
        if (conn == null) {
            throw new ObTableServerConnectException("connection is null");
        }
        return conn;
    }

    private static class ObTableConnectionPool {
        private final int obTableConnectionPoolSize;
        private ObTable obTable;
        private volatile ObTableConnection[] connectionPool;
        private AtomicLong turn = new AtomicLong(0L);
        private final ScheduledExecutorService cleanerExecutor = Executors.newScheduledThreadPool(1);

        public ObTableConnectionPool(ObTable obTable, int connectionPoolSize) {
            this.obTable = obTable;
            this.obTableConnectionPoolSize = connectionPoolSize;
            this.connectionPool = new ObTableConnection[connectionPoolSize];
        }

        public void init() throws Exception {
            for (int i = 0; i < this.obTableConnectionPoolSize; ++i) {
                this.connectionPool[i] = new ObTableConnection(this.obTable);
                if (i == 0) {
                    this.connectionPool[i].enableLoginWithConfigs();
                }
                this.connectionPool[i].init();
            }
            this.cleanerExecutor.scheduleAtFixedRate(this::checkAndReconnect, 0L, 1L, TimeUnit.MINUTES);
        }

        public ObTableConnection getConnection() {
            int round = (int)(this.turn.getAndIncrement() % (long)this.obTableConnectionPoolSize);
            for (int i = 0; i < this.obTableConnectionPoolSize; ++i) {
                int idx = (round + i) % this.obTableConnectionPoolSize;
                if (this.connectionPool[idx].isExpired()) continue;
                return this.connectionPool[idx];
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkAndReconnect() {
            int idx;
            if (this.obTableConnectionPoolSize == 1) {
                return;
            }
            ArrayList<Integer> expiredConnIds = new ArrayList<Integer>();
            long num = this.turn.get();
            for (int i = 1; i <= this.obTableConnectionPoolSize; ++i) {
                int idx2 = (int)(((long)i + num) % (long)this.obTableConnectionPoolSize);
                if (!this.connectionPool[idx2].checkExpired()) continue;
                expiredConnIds.add(idx2);
            }
            int needReconnectCount = (int)Math.ceil((double)expiredConnIds.size() / 3.0);
            for (int i = 0; i < needReconnectCount; ++i) {
                idx = (Integer)expiredConnIds.get(i);
                this.connectionPool[idx].setExpired(true);
            }
            try {
                Thread.sleep(Property.RPC_EXECUTE_TIMEOUT.getDefaultInt());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            for (int i = 0; i < needReconnectCount; ++i) {
                idx = (Integer)expiredConnIds.get(i);
                try {
                    if (i == 0) {
                        this.connectionPool[idx].enableLoginWithConfigs();
                    }
                    this.connectionPool[idx].reConnectAndLogin("expired");
                    continue;
                }
                catch (Exception e) {
                    log.warn("ObTableConnectionPool::checkAndReconnect reconnect fail {}. {}", (Object)this.connectionPool[idx].getConnection().getUrl(), (Object)e.getMessage());
                    continue;
                }
                finally {
                    this.connectionPool[idx].setExpired(false);
                }
            }
        }

        public void close() {
            this.cleanerExecutor.shutdown();
            if (this.connectionPool == null) {
                return;
            }
            for (int i = 0; i < this.connectionPool.length; ++i) {
                if (this.connectionPool[i] == null) continue;
                this.connectionPool[i].close();
                this.connectionPool[i] = null;
            }
        }
    }

    public static class Builder {
        private String ip;
        private int port;
        private String tenantName;
        private String userName;
        private String password;
        private String database;
        private Properties properties = new Properties();
        private Map<String, Object> tableConfigs = new HashMap<String, Object>();

        public Builder(String ip, int port) {
            this.ip = ip;
            this.port = port;
        }

        public Builder setLoginInfo(String tenantName, String userName, String password, String database) {
            this.tenantName = tenantName;
            this.userName = userName;
            this.password = password;
            this.database = database;
            return this;
        }

        public Builder addPropery(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Builder setConfigs(Map<String, Object> tableConfigs) {
            this.tableConfigs = tableConfigs;
            return this;
        }

        public ObTable build() throws Exception {
            ObTable obTable = new ObTable();
            obTable.setIp(this.ip);
            obTable.setPort(this.port);
            obTable.setTenantName(this.tenantName);
            obTable.setUserName(this.userName);
            obTable.setPassword(this.password);
            obTable.setDatabase(this.database);
            obTable.setProperties(this.properties);
            obTable.setConfigs(this.tableConfigs);
            obTable.init();
            return obTable;
        }
    }
}

