/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.exception.ExceptionUtil;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.mutation.result.MutationResult;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperationRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.table.AbstractTableBatchOps;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.remoting.exception.RemotingException;
import java.util.ArrayList;
import java.util.List;

public class ObTableBatchOpsImpl
extends AbstractTableBatchOps {
    private final ObTableBatchOperationRequest request = new ObTableBatchOperationRequest();
    private final ObTableBatchOperation operations = new ObTableBatchOperation();
    private ObTable obTable;

    public ObTableBatchOpsImpl(String tableName, ObTable obTable) {
        super.setTableName(tableName);
        this.obTable = obTable;
        this.request.setTimeout(obTable.getObTableOperationTimeout());
        this.request.setBatchOperation(this.operations);
        this.request.setTableName(tableName);
        this.request.setReturningAffectedRows(true);
    }

    @Override
    public void get(Object[] rowkeys, String[] columns) {
        this.addObTableOperation(ObTableOperationType.GET, rowkeys, columns, null);
    }

    @Override
    public void update(Object[] rowkeys, String[] columns, Object[] values) {
        this.addObTableOperation(ObTableOperationType.UPDATE, rowkeys, columns, values);
    }

    @Override
    public void delete(Object[] rowkeys) {
        this.addObTableOperation(ObTableOperationType.DEL, rowkeys, null, null);
    }

    @Override
    public void insert(Object[] rowkeys, String[] columns, Object[] values) {
        this.addObTableOperation(ObTableOperationType.INSERT, rowkeys, columns, values);
    }

    @Override
    public void replace(Object[] rowkeys, String[] columns, Object[] values) {
        this.addObTableOperation(ObTableOperationType.REPLACE, rowkeys, columns, values);
    }

    @Override
    public void insertOrUpdate(Object[] rowkeys, String[] columns, Object[] values) {
        this.addObTableOperation(ObTableOperationType.INSERT_OR_UPDATE, rowkeys, columns, values);
    }

    @Override
    public void increment(Object[] rowkeys, String[] columns, Object[] values, boolean withResult) {
        this.request.setReturningAffectedEntity(withResult);
        this.addObTableOperation(ObTableOperationType.INCREMENT, rowkeys, columns, values);
    }

    @Override
    public void append(Object[] rowkeys, String[] columns, Object[] values, boolean withResult) {
        this.request.setReturningAffectedEntity(withResult);
        this.addObTableOperation(ObTableOperationType.APPEND, rowkeys, columns, values);
    }

    @Override
    public void put(Object[] rowkeys, String[] columns, Object[] values) {
        this.addObTableOperation(ObTableOperationType.PUT, rowkeys, columns, values);
    }

    public void addObTableOperation(ObTableOperationType type, Object[] rowkeys, String[] columns, Object[] values) {
        ObTableOperation instance = ObTableOperation.getInstance(type, rowkeys, columns, values);
        this.operations.addTableOperation(instance);
    }

    @Override
    public List<Object> execute() throws RemotingException, InterruptedException {
        this.request.setBatchOperationAsAtomic(this.isAtomicOperation());
        this.request.setBatchOpReturnOneResult(this.isReturnOneResult());
        ObPayload result = this.obTable.execute(this.request);
        this.checkObTableOperationResult(result);
        ObTableBatchOperationResult obTableOperationResult = (ObTableBatchOperationResult)result;
        List<ObTableOperationResult> realResults = obTableOperationResult.getResults();
        ArrayList<Object> results = new ArrayList<Object>(realResults.size());
        block3: for (ObTableOperationResult realResult : realResults) {
            int errCode = realResult.getHeader().getErrno();
            if (errCode == ResultCodes.OB_SUCCESS.errorCode) {
                switch (realResult.getOperationType()) {
                    case GET: 
                    case INCREMENT: 
                    case APPEND: {
                        results.add(realResult.getEntity().getSimpleProperties());
                        continue block3;
                    }
                }
                results.add(realResult.getAffectedRows());
                continue;
            }
            results.add(ExceptionUtil.convertToObTableException(this.obTable.getIp(), this.obTable.getPort(), realResult.getSequence(), realResult.getUniqueId(), errCode, realResult.getHeader().getErrMsg()));
        }
        return results;
    }

    @Override
    public List<Object> executeWithResult() throws Exception {
        this.request.setBatchOperationAsAtomic(this.isAtomicOperation());
        this.request.setBatchOpReturnOneResult(this.isReturnOneResult());
        ObPayload result = this.obTable.execute(this.request);
        this.checkObTableOperationResult(result);
        ObTableBatchOperationResult obTableOperationResult = (ObTableBatchOperationResult)result;
        List<ObTableOperationResult> realResults = obTableOperationResult.getResults();
        ArrayList<Object> results = new ArrayList<Object>(realResults.size());
        block4: for (ObTableOperationResult realResult : realResults) {
            int errCode = realResult.getHeader().getErrno();
            if (errCode == ResultCodes.OB_SUCCESS.errorCode) {
                switch (realResult.getOperationType()) {
                    case GET: {
                        throw new ObTableException("Get is not a mutation");
                    }
                    case INCREMENT: 
                    case APPEND: 
                    case INSERT: 
                    case DEL: 
                    case UPDATE: 
                    case INSERT_OR_UPDATE: 
                    case REPLACE: {
                        results.add(new MutationResult(realResult));
                        continue block4;
                    }
                }
                throw new ObTableException("unknown operation type " + (Object)((Object)realResult.getOperationType()));
            }
            results.add(ExceptionUtil.convertToObTableException(this.obTable.getIp(), this.obTable.getPort(), realResult.getSequence(), realResult.getUniqueId(), errCode, realResult.getHeader().getErrMsg()));
        }
        return results;
    }

    @Override
    public void clear() {
        this.operations.getTableOperations().clear();
    }

    private void checkObTableOperationResult(Object result) {
        if (result == null) {
            throw new ObTableException("client get unexpected NULL result");
        }
        if (!(result instanceof ObTableBatchOperationResult)) {
            throw new ObTableException("client get unexpected result: " + result.getClass().getName());
        }
    }

    public void resetObTable(ObTable obTable) {
        this.obTable = obTable;
    }

    @Override
    public ObTableBatchOperation getObTableBatchOperation() {
        return this.operations;
    }
}

